/***************************************************************************
    begin                : Tue May 13 2003
    copyright            : (C) 2003 by John Birch
    email                : jbb@kdevelop.org
	
                          Adapted for ruby debugging
                          --------------------------
    begin                : Mon Nov 1 2004
    copyright            : (C) 2004 by Richard Dale
    email                : Richard_Dale@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _RDBBreakpointWidget_H_
#define _RDBBreakpointWidget_H_

#include <tqhbox.h>
#include <tqpopupmenu.h>

class TQDomElement;
class TQToolButton;
class KURL;

/***************************************************************************/
/***************************************************************************/
/***************************************************************************/

namespace RDBDebugger
{
class Breakpoint;
class BreakpointTableRow;
class RDBTable;

class RDBBreakpointWidget : public TQHBox
{
    Q_OBJECT
  TQ_OBJECT

public:
    RDBBreakpointWidget( TQWidget* parent=0, const char* name=0 );
    virtual ~RDBBreakpointWidget();

    void reset();

    void savePartialProjectSession(TQDomElement* el);
    void restorePartialProjectSession(const TQDomElement* el);


public slots:
    // Connected to from the editor widget:
    void slotToggleBreakpoint(const TQString &filename, int lineNum);
    void slotToggleBreakpointEnabled(const TQString &fileName, int lineNum);

    // Connected to from the variable widget:
    void slotToggleWatchpoint(const TQString &varName);

    // Connected to from the dbgcontroller:
    void slotSetPendingBPs();
    void slotUnableToSetBPNow(int BPNo);
    void slotParseRDBBrkptList(char *str);
    void slotParseRDBBreakpointSet(char *str, int BPKey);

    void slotRefreshBP(const KURL &filename);
    
protected:
    enum BW_ITEMS { BW_ITEM_Show, BW_ITEM_Edit, BW_ITEM_Disable, BW_ITEM_Delete };
    virtual void focusInEvent(TQFocusEvent *e);

private slots:
    void slotRemoveBreakpoint();
    void slotRemoveAllBreakpoints();
    void slotEditBreakpoint(const TQString &fileName, int lineNum);
    void slotEditBreakpoint();
    void slotAddBreakpoint();
    void slotAddBlankBreakpoint(int idx);
    void slotRowDoubleClicked(int row, int col, int button, const TQPoint & mousePos);
    void slotContextMenuShow( int row, int col, const TQPoint &mousePos );
    void slotContextMenuSelect( int item );
    void slotEditRow(int row, int col, const TQPoint & mousePos);
    void slotNewValue(int row, int col);

signals:
    void publishBPState(const Breakpoint& brkpt);
    void refreshBPState(const Breakpoint& brkpt);
    void gotoSourcePosition(const TQString &fileName, int lineNum);
    void clearAllBreakpoints();

private:
    BreakpointTableRow* find(Breakpoint *bp);
    BreakpointTableRow* findId(int id);
    BreakpointTableRow* findKey(int BPKey);

    void setActive();
    BreakpointTableRow* addBreakpoint(Breakpoint *bp);
    void removeBreakpoint(BreakpointTableRow* btr);

private:
    RDBTable*       m_table;

    TQToolButton*    m_add;
    TQToolButton*    m_delete;
    TQToolButton*    m_edit;
    TQToolButton*    m_removeAll;
    TQPopupMenu*     m_ctxMenu;
};

/***************************************************************************/
/***************************************************************************/
/***************************************************************************/

}

#endif
