/***************************************************************************
*   Copyright (C) 2002 by Jakob Simon-Gaarde                              *
*   jsgaarde@tdcspace.dk                                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef SUBCLASSINGDLG_H
#define SUBCLASSINGDLG_H

#include <tqlistview.h>

#include "subclassingdlgbase.h"

class TQStringList;
class TQDomDocument;
class CppSupportPart;

class SlotItem : public TQCheckListItem
{
public:
	SlotItem( TQListView *parent, const TQString &text,
	          const TQString &specifier, const TQString &Access,
	          const TQString &returnType, bool isFunc,
	          bool callBaseClass = false );
	void setAllreadyInSubclass();
	TQString m_access;
	TQString m_methodName;
	TQString m_returnType;
	TQString m_specifier;
	bool m_isFunc;
	bool m_callBaseClass;
	bool m_alreadyInSubclass;
};


class SubclassingDlg : public SubclassingDlgBase
{
public:
	SubclassingDlg( CppSupportPart* cppSupport, const TQString &formFile, TQStringList &newFileNames,
	                TQWidget* parent = 0, const char* name = 0,
	                bool modal = FALSE, WFlags fl = 0 );
	SubclassingDlg( CppSupportPart* cppSupport, const TQString &formFile, const TQString &filename, TQStringList &dummy,
	                TQWidget* parent = 0, const char* name = 0,
	                bool modal = FALSE, WFlags fl = 0 );
	~SubclassingDlg();

private:
	void readUiFile();
	TQString readBaseClassName();
	void updateDlg();
	bool replaceKeywords( TQString &buffer, bool canBeModal = true );
	void replace( TQString &string, const TQString& search, const TQString& replace );
	bool saveBuffer( TQString &buffer, const TQString& filename );
	bool loadBuffer( TQString &buffer, const TQString& filename );
	bool alreadyInSubclass( const TQString &method );
	bool m_creatingNewSubclass;

public slots:
	virtual void accept();
	virtual void onChangedClassName();

protected:
	TQStringList &m_newFileNames;
	TQString m_filename;
	TQString m_formFile;
	TQString m_baseClassName;
	TQString m_qtBaseClassName;
	TQString m_baseCaption;
	TQString m_formName;
	TQString m_formPath;
	TQStringList m_parsedMethods;
	bool m_canBeModal;
	TQValueList<SlotItem*> m_slots;
	TQValueList<SlotItem*> m_functions;
	CppSupportPart* m_cppSupport;
};

#endif 
// kate: indent-mode csands; tab-width 4;

