/***************************************************************************
*   Copyright (C) 2003 by Roberto Raggi                                   *
*   roberto@kdevelop.org                                                  *
*                                                                         *
*   Copyright (C) 2006 by Jens Dagerbo                                    *
*   jens.dagerbo@swipnet.se                                               *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include <klistbox.h>
#include <kcombobox.h>
#include <kapplication.h>
#include <kstandarddirs.h>
#include <kurlrequester.h>
#include <kdebug.h>
#include <klineedit.h>
#include <kmessagebox.h>
#include <klocale.h>

#include <tqfile.h>
#include <tqdir.h>
#include <tqregexp.h>
#include <cstdlib>

#include "settingsdialog.h"

TQListBoxItem* TQListBox_selectedItem( TQListBox* cpTQListBox )
{
	if ( cpTQListBox->selectionMode() != TQListBox::Single )
		return 0;
	if ( cpTQListBox->isSelected( cpTQListBox->currentItem() ) )
		return cpTQListBox->item( cpTQListBox->currentItem() );
	return 0;
}

SettingsDialog::SettingsDialog( TQWidget* parent, const char* name, WFlags fl )
: SettingsDialogBase( parent, name, fl )
{
	KApplication::kApplication()->dirs()->addResourceType("include","include");
	TQStringList kdedirs=KApplication::kApplication()->dirs()->findDirs("include","");
	for( TQStringList::Iterator it=kdedirs.begin(); it!=kdedirs.end();    ++it )
	{
		TQString kdedir = *it;
		if ( !kdedir.isEmpty() && isValidKDELibsDir( kdedir ) )
			if ( !kdeListBox->findItem( kdedir, ExactMatch ) )
				kdeListBox->insertItem( kdedir );
	}

	kdeUrl->setMode( KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly );

	connect( addUrlButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(addUrlButton_clicked()) );
}

SettingsDialog::~SettingsDialog()
{}

void SettingsDialog::slotSelectionChanged( TQListBoxItem* )
{
	emit enabled( kdeListBox->selectedItem() != 0 );
}

bool SettingsDialog::isValidKDELibsDir( const TQString & path ) const
{
	return TQFile::exists( path + "/kapplication.h" );
}

TQString SettingsDialog::kdeDir( ) const
{
	return kdeListBox->currentText();
}

void SettingsDialog::addUrlButton_clicked()
{
	kdDebug(9000) << k_funcinfo << endl;

	if ( isValidKDELibsDir( kdeUrl->url() ) )
	{
		kdeListBox->insertItem( kdeUrl->url() );
		if ( TQListBoxItem * item = kdeListBox->findItem( kdeUrl->url(), ExactMatch ) )
		{
			kdeListBox->setSelected( item, true );
		}
		kdeUrl->lineEdit()->clear();
	}
	else
	{
		KMessageBox::error( this, i18n("This does not appear to be a valid KDE include directory.\nPlease select a different directory."), i18n("Invalid Directory") );
	}
}


#include "settingsdialog.moc"
//kate: indent-mode csands; tab-width 4; space-indent off;



