%{CPP_TEMPLATE}

#include <tqfileinfo.h>
#include <tqframe.h>

#include <kparts/part.h>
#include <kate/document.h>
#include <kate/view.h>
#include <klocale.h>
#include <klibloader.h>
#include <kurl.h>

#include "kmdikonsole.h"

kmdikonsole::kmdikonsole(TQWidget *parent, const char *name) : TQVBox(parent, name)
{
	m_haskonsole = false;
	respawn();
}

kmdikonsole::~kmdikonsole()
{
}

void kmdikonsole::respawn()
{
	KLibFactory *factory = KLibLoader::self()->factory("libkonsolepart");

	if (!factory) return;
	m_part = (KParts::ReadOnlyPart *) factory->create(this);

	if (!m_part) return;

	if (m_part->widget()->inherits(TQFRAME_OBJECT_NAME_STRING))
		((TQFrame*)m_part->widget())->setFrameStyle(TQFrame::Panel|TQFrame::Sunken);

	m_haskonsole=true;
	connect( m_part, TQT_SIGNAL(destroyed()), this, TQT_SLOT(slotDestroyed()) );

	m_part->widget()->show();
	show();
}

void kmdikonsole::setDirectory(const TQString &dirname)
{
	if (m_haskonsole)
	{
		KURL url(dirname);
		if (m_part->url() != url)
			m_part->openURL(url);
	}
}

void kmdikonsole::showEvent(TQShowEvent *ev)
{
	TQWidget::showEvent(ev);
	activate();
}

void kmdikonsole::activate()
{
	if (m_haskonsole)
	{
		m_part->widget()->show();
		setFocusProxy(m_part->widget());
		m_part->widget()->setFocus();
	}
}

void kmdikonsole::slotDestroyed()
{
	m_haskonsole=false;
	respawn();
}

#include "kmdikonsole.moc"
