/***************************************************************************
*   Copyright (C) 2001 by Bernd Gehrmann                                  *
*   bernd@kdevelop.org                                                    *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef _FILESELECTORWIDGET_H_
#define _FILESELECTORWIDGET_H_

#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tqhbox.h>
#include <tqlabel.h>
#include <tqstrlist.h>
#include <tqtooltip.h>

#include <klistview.h>
#include <tqvbox.h>
#include <tqwidget.h>
#include <kfile.h>
#include <kurlcombobox.h>
#include <kurlcompletion.h>
#include <kcombobox.h>
#include <kprotocolinfo.h>

#include <kfileview.h>
#include <kfileitem.h>

#include <kdiroperator.h>

class AutoProjectPart;
class SubprojectItem;
class KFile;

class KDnDDirOperator : public KDirOperator
{
	Q_OBJECT
  TQ_OBJECT

public:
	KDnDDirOperator ( const KURL& urlName = KURL(), TQWidget *parent = 0, const char* name = 0 );

protected:
	virtual KFileView* createView( TQWidget* parent, KFile::FileView view );
};

class FileSelectorWidget : public TQWidget
{
	Q_OBJECT
  TQ_OBJECT

public:
	FileSelectorWidget( AutoProjectPart* part, KFile::Mode, TQWidget* parent = 0, const char* name = 0 );
	~FileSelectorWidget();

	KDnDDirOperator * dirOperator()
	{
		return dir;
	}

public slots:
	void slotFilterChanged( const TQString& );
	void setDir( KURL );
	void setDir( const TQString& );

private slots:
	void cmbPathActivated( const KURL& u );
	void cmbPathReturnPressed( const TQString& u );
	void dirUrlEntered( const KURL& u );
	void dirFinishedLoading();
	void filterReturnPressed( const TQString& nf );

protected:
	void focusInEvent( TQFocusEvent* );
	void dragEnterEvent ( TQDragEnterEvent* ev );
	void dropEvent ( TQDropEvent* ev );

private:
	KURLComboBox *cmbPath;
	KHistoryCombo * filter;
	TQLabel* filterIcon;
	KDnDDirOperator * dir;
	TQPushButton *home, *up, *back, *forward;
	AutoProjectPart* m_part;

signals:
	void dropped ( const TQString& );

};

#endif 
// kate: indent-mode csands; tab-width 4;

