#ifndef _ANTPROJECTPART_H_
#define _ANTPROJECTPART_H_


#include <tqstring.h>
#include <tqstringlist.h>
#include <tqmap.h>


class TQPopupMenu;


class KAction;
class KDialogBase;
class Context;
class ClassPathWidget;


#include "kdevbuildtool.h"


class AntOptionsWidget;


class AntOptions
{
public:

  AntOptions();

  enum Verbosity { Quiet, Verbose, Debug };

  TQString m_buildXML;
  TQString m_defaultTarget;
  TQStringList m_targets;
  TQMap<TQString,TQString> m_properties;
  TQMap<TQString,bool> m_defineProperties;
  Verbosity m_verbosity;
  
};


class AntProjectPart : public KDevBuildTool
{
  Q_OBJECT
  TQ_OBJECT

public:
	  
  AntProjectPart(TQObject *parent, const char *name, const TQStringList &args);
  ~AntProjectPart();
    TQStringList distFiles() const;


protected:

  virtual void openProject(const TQString &dirName, const TQString &projectName);
  virtual void closeProject();

  virtual TQString projectDirectory() const;
  virtual TQString projectName() const;
  virtual TQString mainProgram() const;
  virtual TQString activeDirectory() const;
  virtual TQStringList allFiles() const;
  virtual TQString buildDirectory() const;
  virtual TQString runDirectory() const;
  virtual TQString runArguments() const;
  virtual TQString debugArguments() const;
  virtual DomUtil::PairList runEnvironmentVars() const;

  virtual void addFile(const TQString &fileName);
  virtual void addFiles ( const TQStringList &fileList );
  virtual void removeFile(const TQString &fileName);
  virtual void removeFiles ( const TQStringList& fileList );


private slots:

  void slotBuild();
  void slotTargetMenuActivated(int id);

  void projectConfigWidget(KDialogBase *dlg);
  void contextMenu(TQPopupMenu *popup, const Context *context);

  void optionsAccepted();

  void slotAddToProject();
  void slotRemoveFromProject();


private:

  void parseBuildXML();
  void fillMenu();
  void populateProject();

  void ant(const TQString &target);

  TQString m_projectDirectory, m_projectName;
  TQStringList m_classPath;

  TQStringList m_sourceFiles;

  AntOptions m_antOptions;

  KAction *m_buildProjectAction;

  TQPopupMenu *m_targetMenu;

  AntOptionsWidget *m_antOptionsWidget;
  ClassPathWidget *m_classPathWidget;

  TQString m_contextFileName;

};


#endif
