/***************************************************************************
 *   Copyright (C) 2006-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#include "modifiedthread.h"
#include "tcontextlistener.h"

#include "src/svnqt/svnqttypes.hpp"

#include <tqobject.h>
#include <kdebug.h>
#include <kapplication.h>

CheckModifiedThread::CheckModifiedThread(TQObject*_parent,const TQString&what,bool _updates)
    : TQThread(),mutex(),m_ContextListener(0)
{
    m_Parent = _parent;
    m_CurrentContext = new svn::Context();
    m_ContextListener = new ThreadContextListener(m_Parent);
    TQObject::connect(m_ContextListener,TQT_SIGNAL(sendNotify(const TQString&)),m_Parent,TQT_SLOT(slotNotifyMessage(const TQString&)));

    m_CurrentContext->setListener(m_ContextListener);
    m_what = what;
    m_Svnclient = svn::Client::getobject(m_CurrentContext,0);
    m_updates = _updates;
}

CheckModifiedThread::~CheckModifiedThread()
{
    m_CurrentContext->setListener(0);
    delete m_Svnclient;
    m_ContextListener=0;
}

void CheckModifiedThread::cancelMe()
{
    // method is threadsafe!
    m_ContextListener->setCanceled(true);
}

const svn::StatusEntries&CheckModifiedThread::getList()const
{
    return m_Cache;
}

void CheckModifiedThread::run()
{
    // what must be cleaned!
    svn::Revision where = svn::Revision::HEAD;
    TQString ex;
    try {
        //                                  rec  all    up        noign
        m_Cache = m_Svnclient->status(m_what,svn::DepthInfinity,false,m_updates,false,where);
    } catch (const svn::Exception&e) {
        m_ContextListener->contextNotify(e.msg());
    }
    KApplication*k = KApplication::kApplication();
    if (k) {
        TQCustomEvent*ev = new TQCustomEvent(EVENT_THREAD_FINISHED);
        ev->setData((void*)this);
        k->postEvent(m_Parent,ev);
    }
}
