/***************************************************************************
    begin                : Sat Jan 11 2003
    copyright            : (C) 2003 by kiriuja
    email                : kplayer-dev@en-directo.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* Taken from kplayer CVS 2003-09-21 (kplayer > 0.3.1) by Jonathan Riddell
 * Changes from kplayer original marked by CHANGED
 */

#include <kapplication.h>
#include <ktoolbar.h>
#include <ktoolbarbutton.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>

#include <kdebug.h>

//CHANGED #include "kplayersettings.h"
#include "kplayerslideraction.h"
#include "kplayerslideraction.moc"

void KPlayerPopupFrame::keyPressEvent (TQKeyEvent* ev)
{
    switch ( ev -> key() )
    {
    case TQt::Key_Alt:
    case TQt::Key_Tab:
    case TQt::Key_Escape:
    case TQt::Key_Return:
    case TQt::Key_Enter:
        close();
    }
}

/*void KPlayerPopupFrame::closeEvent (TQCloseEvent* ev)
{
  TQFrame::closeEvent (ev);
}

void KPlayerPopupFrame::mousePressEvent (TQMouseEvent* ev)
{
  TQFrame::mousePressEvent (ev);
//if ( ! rect().contains (ev -> pos()) )
//  m_outside_mouse_press = true;
}

void KPlayerPopupFrame::mouseReleaseEvent (TQMouseEvent* ev)
{
  TQFrame::mouseReleaseEvent (ev);
  if ( m_outside_mouse_press )
  {
    m_outside_mouse_press = false;
    if ( ! rect().contains (ev -> pos()) )
      close();
  }
}*/

KPlayerPopupSliderAction::KPlayerPopupSliderAction (const TQString& text,
        const TQString& pix, const KShortcut& shortcut, const TQObject* receiver,
        const char* slot, TQObject* parent, const char* name)
        : KAction (text, pix, shortcut, parent, name)
{
    m_frame = new KPlayerPopupFrame;
    m_frame -> setFrameStyle (TQFrame::PopupPanel | TQFrame::Raised);
    m_frame -> setLineWidth (2);
    m_slider = new KPlayerSlider (Qt::Vertical, m_frame);
    m_frame -> resize (36, m_slider -> sizeHint().height() + 4);
    m_slider -> setGeometry (m_frame -> contentsRect());
    //CHANGED  kdDebug() << "Popup slider size " << m_slider -> width() << "x" << m_slider -> height() << "\n";
    connect (m_slider, TQT_SIGNAL (changed (int)), receiver, slot);
}

KPlayerPopupSliderAction::~KPlayerPopupSliderAction()
{
    delete m_frame;
    m_frame = 0;
}

/*int KPlayerPopupSliderAction::plug (TQWidget* widget, int index)
{
  Q_ASSERT (m_slider);
  Q_ASSERT (widget);
  Q_ASSERT (! isPlugged());
  if ( ! m_slider || ! widget || isPlugged() )
    return -1;
  Q_ASSERT (widget -> inherits ("KToolBar"));
  if ( ! widget -> inherits ("KToolBar") )
    return -1;
  int retval = KAction::plug (widget, index);
//  if ( retval >= 0 )
//    m_slider -> reparent (widget, TQPoint());
  return retval;
}

void KPlayerPopupSliderAction::unplug (TQWidget* widget)
{
  Q_ASSERT (m_slider);
  Q_ASSERT (widget);
  Q_ASSERT (isPlugged());
  Q_ASSERT (widget -> inherits ("KToolBar"));
  if ( ! m_slider || ! widget || ! isPlugged() || ! widget -> inherits ("KToolBar") )
    return;
//m_slider -> reparent (0, TQPoint());
  KAction::unplug (widget);
}*/

void KPlayerPopupSliderAction::slotActivated (void)
{
    KAction::slotActivated();
    TQWidget* button = 0;
    if ( sender() )
    {
        //CHANGED    kdDebug() << "Sender class name: " << sender() -> className() << "\n";
        if ( sender() -> inherits ("KToolBarButton") )
            button = (TQWidget*) sender();
        else if ( sender() -> inherits ("KToolBar") )
        {
            KToolBar* toolbar = (KToolBar*) sender();
            int index = findContainer (toolbar);
            if ( index >= 0 )
                button = toolbar -> getButton (itemId (index));
        }
    }
    TQPoint point;
    if ( button )
        point = button -> mapToGlobal (TQPoint (0, button -> height()));
    else
    {
        point = TQCursor::pos() - TQPoint (m_frame -> width() / 2, m_frame -> height() / 2);
        if ( point.x() + m_frame -> width() > TQApplication::desktop() -> width() )
            point.setX (TQApplication::desktop() -> width() - m_frame -> width());
        if ( point.y() + m_frame -> height() > TQApplication::desktop() -> height() )
            point.setY (TQApplication::desktop() -> height() - m_frame -> height());
        if ( point.x() < 0 )
            point.setX (0);
        if ( point.y() < 0 )
            point.setY (0);
    }
    //CHANGED  kdDebug() << "Point: " << point.x() << "x" << point.y() << "\n";
    m_frame -> move (point);
    /*if ( kapp && kapp -> activeWindow() )
      {
        TQMouseEvent me (TQEvent::MouseButtonRelease, TQPoint(0,0), TQPoint(0,0), TQMouseEvent::LeftButton, TQMouseEvent::NoButton);
        TQApplication::sendEvent (kapp -> activeWindow(), &me);
      }*/
    m_frame -> show();
    m_slider -> setFocus();
}

KPlayerSliderAction::KPlayerSliderAction (const TQString& text, const KShortcut& cut,
        const TQObject* receiver, const char* slot, KActionCollection* parent, const char* name)
        : KWidgetAction (new KPlayerSlider (Qt::Horizontal, 0, name), text, cut, receiver, slot, parent, name)
        //: KAction (text, 0, parent, name)
{
    setAutoSized (true);
    connect (slider(), TQT_SIGNAL (changed (int)), receiver, slot);
}

KPlayerSliderAction::~KPlayerSliderAction()
{
}

int KPlayerSliderAction::plug (TQWidget* widget, int index)
{
    //Q_ASSERT (widget);
    //Q_ASSERT (! isPlugged());
    //Q_ASSERT (slider());
    //if ( ! slider() || ! widget || isPlugged() )
    //  return -1;
    //Q_ASSERT (widget -> inherits ("KToolBar"));
    //if ( ! widget -> inherits ("KToolBar") )
    //  return -1;
    //if ( kapp && ! kapp -> authorizeKAction (name()) )
    //  return -1;
    int result = KWidgetAction::plug (widget, index);
    if ( result < 0 )
        return result;
    KToolBar* toolbar = (KToolBar*) widget;
    //int id = getToolButtonID();
    //kdDebug() << "Qt::Orientation: " << toolbar -> orientation() << "\n";
    //m_slider -> reparent (toolbar, TQPoint());
    //toolbar -> insertWidget (id, 0, m_slider, index);
    //toolbar -> setItemAutoSized (id, true);
    //TQWhatsThis::remove (m_slider);
    //if ( ! whatsThis().isEmpty() )
    //  TQWhatsThis::add (m_slider, whatsThis());
    //if ( ! text().isEmpty() )
    //  TQToolTip::add (m_slider, text());
    //addContainer (toolbar, id);
    //setupToolbar (toolbar -> orientation(), toolbar);
    orientationChanged (toolbar -> orientation());
    connect (toolbar, TQT_SIGNAL (orientationChanged (Qt::Orientation)), this, TQT_SLOT (orientationChanged (Qt::Orientation)));
    //connect (toolbar, TQT_SIGNAL (destroyed()), this, TQT_SLOT (toolbarDestroyed()));
    //if ( parentCollection() )
    //  parentCollection() -> connectHighlight (toolbar, this);
    //return containerCount() - 1;
    return result;
}

void KPlayerSliderAction::unplug (TQWidget* widget)
{
    //Q_ASSERT (m_slider);
    //Q_ASSERT (isPlugged());
    //Q_ASSERT (widget -> inherits ("KToolBar"));
    KWidgetAction::unplug (widget);
    if ( ! slider() || ! isPlugged() || TQT_BASE_OBJECT(widget) != TQT_BASE_OBJECT(slider() -> parent()) )
        return;
    //KToolBar* toolbar = (KToolBar*) widget;
    disconnect (widget, TQT_SIGNAL (orientationChanged (Qt::Orientation)), this, TQT_SLOT (orientationChanged (Qt::Orientation)));
    //disconnect (toolbar, TQT_SIGNAL (destroyed()), this, TQT_SLOT (toolbarDestroyed()));
    //m_slider -> reparent (0, TQPoint());
    /*int index = findContainer (toolbar);
      if ( index == -1 )
        return;
      bar -> removeItem (menuId (index));
      removeContainer (index);*/
}

/*void KPlayerSliderAction::setupToolbar (Qt::Orientation orientation, KToolBar* toolbar)
{
    if ( orientation == Qt::Horizontal )
    {
//      toolbar -> setMinimumWidth (300);
//      toolbar -> setMinimumHeight (0);
      toolbar -> setFixedExtentWidth (300);
      toolbar -> setFixedExtentHeight (-1);
//      toolbar -> setHorizontallyStretchable (true);
//      toolbar -> setVerticallyStretchable (false);
    }
    else
    {
//      toolbar -> setMinimumWidth (0);
//      toolbar -> setMinimumHeight (300);
      toolbar -> setFixedExtentWidth (-1);
      toolbar -> setFixedExtentHeight (300);
//      toolbar -> setHorizontallyStretchable (false);
//      toolbar -> setVerticallyStretchable (true);
    }
}*/

void KPlayerSliderAction::orientationChanged (Qt::Orientation orientation)
{
    //if ( sender() && sender() -> inherits ("KToolBar") )
    //  setupToolbar (orientation, (KToolBar*) sender());
    //Q_ASSERT (m_slider);
    //Q_ASSERT (isPlugged());
    if ( slider() )
        slider() -> setOrientation (orientation);
}

/*void KPlayerSliderAction::toolbarDestroyed (void)
{
  if ( m_slider )
    m_slider -> reparent (0, TQPoint());
}*/

KPlayerSlider::KPlayerSlider (Qt::Orientation orientation, TQWidget* parent, const char* name)
//CHANGED  : TQSlider (orientation, parent, name)
        : TQSlider (300, 2200, 400, 1000, orientation, parent, name)
{
    m_changing_orientation = false;
    setTickmarks (TQSlider::Both);
    connect (this, TQT_SIGNAL (valueChanged (int)), this, TQT_SLOT (sliderValueChanged (int)));
}

KPlayerSlider::~KPlayerSlider()
{
    //CHANGED  kdDebug() << "KPlayerSlider destroyed\n";
}

TQSize KPlayerSlider::sizeHint() const
{
    TQSize hint = TQSlider::sizeHint();
    //CHANGED int length = kPlayerSettings() -> preferredSliderLength();
    int length = 200;
    if ( orientation() == Qt::Horizontal )
    {
        if ( hint.width() < length )
            hint.setWidth (length);
    }
    else
    {
        if ( hint.height() < length )
            hint.setHeight (length);
    }
    return hint;
}

TQSize KPlayerSlider::minimumSizeHint() const
{
    //kdDebug() << "KPlayerSlider minimum size hint\n";
    TQSize hint = TQSlider::minimumSizeHint();
    //CHANGED  int length = kPlayerSettings() -> minimumSliderLength();
    int length = 200;
    if ( orientation() == Qt::Horizontal )
    {
        if ( hint.width() < length )
            hint.setWidth (length);
    }
    else
    {
        if ( hint.height() < length )
            hint.setHeight (length);
    }
    return hint;
}

void KPlayerSlider::setOrientation (Qt::Orientation o)
{
    if ( o == orientation() )
        return;
    m_changing_orientation = true;
    int minValue = TQSlider::minValue();
    int maxValue = TQSlider::maxValue();
    int value = TQSlider::value();
    TQSlider::setOrientation (o);
    TQSlider::setMinValue (- maxValue);
    TQSlider::setMaxValue (- minValue);
    TQSlider::setValue (- value);
    m_changing_orientation = false;
}

int KPlayerSlider::minValue (void) const
{
    if ( orientation() == Qt::Horizontal )
        return TQSlider::minValue();
    return - TQSlider::maxValue();
}

void KPlayerSlider::setMinValue (int minValue)
{
    if ( orientation() == Qt::Horizontal )
        TQSlider::setMinValue (minValue);
    else
        TQSlider::setMaxValue (- minValue);
}

int KPlayerSlider::maxValue (void) const
{
    if ( orientation() == Qt::Horizontal )
        return TQSlider::maxValue();
    return - TQSlider::minValue();
}

void KPlayerSlider::setMaxValue (int maxValue)
{
    if ( orientation() == Qt::Horizontal )
        TQSlider::setMaxValue (maxValue);
    else
        TQSlider::setMinValue (- maxValue);
}

int KPlayerSlider::lineStep (void) const
{
    return TQSlider::lineStep();
}

void KPlayerSlider::setLineStep (int lineStep)
{
    TQSlider::setLineStep (lineStep);
}

int KPlayerSlider::pageStep (void) const
{
    return TQSlider::pageStep();
}

void KPlayerSlider::setPageStep (int pageStep)
{
    TQSlider::setPageStep (pageStep);
    setTickInterval (pageStep);
}

int KPlayerSlider::value (void) const
{
    if ( orientation() == Qt::Horizontal )
        return TQSlider::value();
    return - TQSlider::value();
}

void KPlayerSlider::setValue (int value, int)
{
    if ( orientation() == Qt::Horizontal )
        TQSlider::setValue (value);
    else
        TQSlider::setValue (- value);
}

void KPlayerSlider::setup (int minValue, int maxValue, int value, int pageStep, int lineStep)
{
    setMinValue (minValue);
    setMaxValue (maxValue);
    setLineStep (lineStep);
    setPageStep (pageStep);
    setValue (value);
}

void KPlayerSlider::sliderValueChanged (int)
{
    if ( ! m_changing_orientation )
        emit changed (value());
}
