/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2003-2006                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Mon Jun 23 2003
 */

#ifndef CPPCODEGENERATIONPOLICY_H
#define CPPCODEGENERATIONPOLICY_H

#include <tqstring.h>
#include "codegenpolicyext.h"
#include "../codegenerationpolicy.h"

class KConfig;
class CodeGenerationPolicyPage;

class CPPCodeGenerationPolicy : public CodeGenPolicyExt
{
    Q_OBJECT
  TQ_OBJECT
public:

    static const bool DEFAULT_AUTO_GEN_EMPTY_CONSTRUCTORS;
    static const bool DEFAULT_AUTO_GEN_ACCESSORS;
    static const bool DEFAULT_INLINE_ACCESSORS;
    static const bool DEFAULT_INLINE_OPERATIONS;
    static const bool DEFAULT_VIRTUAL_DESTRUCTORS;
    static const bool DEFAULT_PACKAGE_IS_NAMESPACE;
    static const bool DEFAULT_PUBLIC_ACCESSORS;

    static const bool DEFAULT_STRING_INCLUDE_GLOBAL;
    static const bool DEFAULT_VECTOR_INCLUDE_GLOBAL;

    static const char * DEFAULT_STRING_CLASS_NAME;
    static const char * DEFAULT_STRING_CLASS_INCLUDE;
    static const char * DEFAULT_VECTOR_CLASS_NAME;
    static const char * DEFAULT_VECTOR_CLASS_INCLUDE;
    static const char * DEFAULT_VECTOR_METHOD_APPEND;
    static const char * DEFAULT_VECTOR_METHOD_REMOVE;
    static const char * DEFAULT_VECTOR_METHOD_INIT;
    static const char * DEFAULT_OBJECT_METHOD_INIT;

    // Constructors/Destructors
    //

    /**
     * Constructors
     */
    CPPCodeGenerationPolicy ( KConfig * config = 0 );

    /**
     * Empty Destructor
     */
    virtual ~CPPCodeGenerationPolicy ( );

    // Public attribute accessor methods
    //

    /**
     * Set the value of m_inlineAccessors
     * @param var the new value
     */
    void setAccessorsAreInline ( bool var );

    /**
     * Get the value of m_inlineAccessors
     * @return value the boolean value of m_inlineAccessors
     */
    bool getAccessorsAreInline( );

    /**
     * Set the value of m_inlineOperations
     * @param var the new value
     */
    void setOperationsAreInline ( bool var );

    /**
     * Get the value of m_inlineOperations
     * @return value the boolean value of m_inlineOperations
     */
    bool getOperationsAreInline( );

    /**
      * Set the value of m_virtualDestructors
      * @param var the new value
      */
    void setDestructorsAreVirtual ( bool var );

    /**
     * Get the value of m_virtualDestructors
     * @return value the boolean value of m_virtualDestructors
     */
    bool getDestructorsAreVirtual( );

    /**
       * Set the value of m_packageIsNamespace
       * @param var the new value
       */
    void setPackageIsNamespace ( bool var );

    /**
     * Get the value of m_packageIsNamespace
     * @return value the boolean value of m_packageIsNamespace
     */
    bool getPackageIsNamespace( );


    /**
      * Set the value of m_autoGenerateAccessors
      * @param var the new value
      */
    void setAutoGenerateAccessors ( bool var );

    /**
      * Get the value of m_autoGenerateAccessors
      * @return value the boolean value of m_autoGenerateAccessors
      */
    bool getAutoGenerateAccessors( );

    /**
     * Set the value of m_publicAccessors
     * @param var the new value
     */
    void setAccessorsArePublic ( bool var );

    /**
     * Get the value of m_publicAccessors
     * @return value the boolean value of m_inlineAccessors
     */
    bool getAccessorsArePublic( );

    /** We want to be flexible about which classes are allowed for generation
     * of the CPP code. In the next 4 methods, we give accessors that allow getting
     * the names of the classes, and their include files for string and vectors.
     */
    TQString getStringClassName();
    TQString getStringClassNameInclude();
    TQString getVectorClassName();
    TQString getVectorClassNameInclude();

    /** determine if the string include is global one */
    bool stringIncludeIsGlobal ();
    bool vectorIncludeIsGlobal ();

    /** also allow setting these parameters! */
    void setStringClassName(const TQString &value);
    void setStringClassNameInclude(const TQString &value);
    void setVectorClassName(const TQString &value);
    void setVectorClassNameInclude(const TQString &value);

    /** allow setting of these params */
    void setStringIncludeIsGlobal (bool value);
    void setVectorIncludeIsGlobal (bool value);

    /** More flexible generation. We want to allow the user to specify how the
     *  bodies of the vector methods should be auto-generated.
     */
    TQString getVectorMethodAppend(const TQString & variableName ="", const TQString & itemClassName = "");
    TQString getVectorMethodRemove(const TQString & variableName ="", const TQString & itemClassName = "");
    TQString getVectorMethodInit(const TQString & variableName ="", const TQString & itemClassName = "");

    /** Be somewhat flexible about how new object classes are initialized.
     * Not sure if this should be user configureable. For now, it isnt.
     */
    TQString getObjectMethodInit(const TQString & variableName ="", const TQString & itemClassName = "");

    /**
     * set the defaults for this code generator from the passed generator.
     */
    virtual void setDefaults (CPPCodeGenerationPolicy * defaults, bool emitUpdateSignal = true);

    /**
     * set the defaults from a config file for this code generator from the passed KConfig pointer.
     */
    virtual void setDefaults(KConfig * config, bool emitUpdateSignal = true);

    /**
     * write Default params to passed KConfig pointer.
     */
    virtual void writeConfig (KConfig * config);

    /**
     * Create a new dialog interface for this object.
     * @return dialog object
     */
    CodeGenerationPolicyPage * createPage ( TQWidget *parent = 0, const char * name = 0);

protected:

    /**
     */
    void init ( );

private:

    bool m_autoGenerateAccessors;

    bool m_inlineAccessors;
    bool m_inlineOperations;
    bool m_virtualDestructors;
    bool m_packageIsNamespace;
    bool m_publicAccessors;

    bool m_stringIncludeIsGlobal;
    bool m_vectorIncludeIsGlobal;

    TQString m_stringClassName;
    TQString m_stringClassNameInclude;
    TQString m_vectorClassName;
    TQString m_vectorClassNameInclude;
    TQString m_vectorMethodAppendBase;
    TQString m_vectorMethodRemoveBase;
    TQString m_vectorMethodInitBase;
    TQString m_objectMethodInitBase;

};

#endif // CPPCODEGENERATIONPOLICY_H
