#ifndef PACKAGESELECTDIALOG_H
#define PACKAGESELECTDIALOG_H

#include <tqdict.h>

#include <kdialogbase.h>

#include "package.h"

class KCompletion;
class KLineEdit;

class PackageListView : public TQListView
{
    Q_OBJECT
  TQ_OBJECT
  public:
    PackageListView( TQWidget *parent );

    void resetTyped();

  signals:
    void typed( const TQString & );

  protected:
    void keyPressEvent( TQKeyEvent *e );
    
  private:
    TQString mTyped;
};

class PackageSelectDialog : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT
  public:
    PackageSelectDialog(TQWidget *parent=0,const char *name=0);
    ~PackageSelectDialog();

    void setRecentPackages( const TQStringList & );
    void setPackages( const Package::List &pkgs );

    Package selectedPackage();
    TQString selectedComponent();

  protected slots:
    void slotOk();

  private slots:
    void recentSelected( int, TQListViewItem * );
    void completeSelected( int, TQListViewItem * );
    void completeTyped( const TQString & );

  private:
    Package::List mPackages;
    Package mSelectedPackage;
    TQString mSelectedComponent;
    
    TQListView *mRecentList;
    PackageListView *mCompleteList;
    KLineEdit *mPackageEdit;
    KCompletion *mCompletion;
    TQDict<TQListViewItem> mCompletionDict;
};

#endif
