/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2001 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2003	  by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.
	    
**************************************************************************** */
#ifndef DICTCHOOSER_H
#define DICTCHOOSER_H

#include <tqptrlist.h>
#include <tqstringlist.h>
#include <tqwidget.h>
#include <kbabeldictbox.h>

class KListBox;
class KTempFile;

class TQPushButton;
class TQListBoxItem;


class KDE_EXPORT DictChooser : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT

public:
    DictChooser(KBabelDictBox* box, TQStringList selected, 
            TQWidget *parent , const char *name=0);

    TQStringList selectedDicts();
    
    /** If the user configured some of the modules, this 
     *  restores the original configuration of all these modules
     */
    void restoreConfig();

    virtual bool eventFilter(TQObject *, TQEvent *);
    
private slots:
    void select();
    void unselect();
    void up();
    void down();

    void selectedMarked(int);
    void unselectedMarked(int);

    void configureSelected();
    
private:
    KBabelDictBox* box;
    TQPtrList<ModuleInfo> dictList;

    KListBox *selectedBox;
    KListBox *unselectedBox;
    
    TQPushButton *selectBtn;
    TQPushButton *unselectBtn;
    TQPushButton *upBtn;
    TQPushButton *downBtn;
    TQPushButton *configureBtn;
    
    TQDict<KTempFile> tempConfig;
};

#endif // DICTCHOOSER_H
