/*
    This file is part of KOrganizer.
    Copyright (c) 2000,2001 Cornelius Schumacher <schumacher@kde.org>
    Copyright (C) 2003-2004 Reinhold Kainhofer <reinhold@kainhofer.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/
#ifndef KOEVENTPOPUPMENU_H
#define KOEVENTPOPUPMENU_H
//
// Context menu for event views with standard event actions
//

#include <tqpopupmenu.h>
#include <tqdatetime.h>

namespace KCal {
class Calendar;
class Incidence;
}
using namespace KCal;

class KOEventPopupMenu : public TQPopupMenu {
    Q_OBJECT
  TQ_OBJECT
  public:
    KOEventPopupMenu();

    void addAdditionalItem(const TQIconSet &icon,const TQString &text,
                           const TQObject *receiver, const char *member,
                           bool editOnly=false);


  public slots:
    void showIncidencePopup( Calendar *, Incidence *, const TQDate & );

  protected slots:
    void popupShow();
    void popupEdit();
    void popupPaste();
    void print();
    void popupDelete();
    void popupCut();
    void popupCopy();
    void popupAlarm();
    void dissociateOccurrence();
    void dissociateFutureOccurrence();
    void forward();

  signals:
    void configChanged();
    void editIncidenceSignal( Incidence *, const TQDate & );
    void showIncidenceSignal( Incidence *, const TQDate & );
    void deleteIncidenceSignal( Incidence * );
    void cutIncidenceSignal( Incidence * );
    void copyIncidenceSignal( Incidence * );
    void pasteIncidenceSignal();
    void toggleAlarmSignal( Incidence * );
    void dissociateOccurrenceSignal( Incidence *, const TQDate & );
    void dissociateFutureOccurrenceSignal( Incidence *, const TQDate & );

  private:
    Calendar *mCalendar;
    Incidence *mCurrentIncidence;
    TQDate mCurrentDate;

    bool mHasAdditionalItems;
    TQValueList<int> mEditOnlyItems;
    TQValueList<int> mRecurrenceItems;
};

#endif
