// -*- mode: C++; c-file-style: "gnu" -*-
/**
 * folderdiaquotatab.h
 *
 * Copyright (c) 2006 Till Adam <adam@kde.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of this program with any edition of
 *  the TQt library by Trolltech AS, Norway (or with modified versions
 *  of TQt that use the same license as TQt), and distribute linked
 *  combinations including the two.  You must obey the GNU General
 *  Public License in all respects for all of the code used other than
 *  TQt.  If you modify this file, you may extend this exception to
 *  your version of the file, but you are not obligated to do so.  If
 *  you do not wish to do so, delete this exception statement from
 *  your version.
 */
#ifndef FOLDERDIAQUOTA_H
#define FOLDERDIAQUOTA_H

#include "kmfolderdia.h"
#include "kmfoldertype.h"
#include "quotajobs.h"

namespace KMail {
  class QuotaWidget;
}
class TQVBox;
class TQWidgetStack;

namespace KMail {

class ImapAccountBase;

/**
 * "Quota" tab in the folder dialog
 * Internal class, only used by KMFolderDialog
 */
class FolderDiaQuotaTab : public FolderDiaTab
{
  Q_OBJECT
  TQ_OBJECT

public:
  FolderDiaQuotaTab( KMFolderDialog* dlg, TQWidget* parent, const char* name = 0 );

  virtual void load();
  virtual bool save();
  virtual AccepStatus accept();

  static bool supports( KMFolder* refFolder );

private:
  void initializeWithValuesFromFolder( KMFolder* folder );
  void showQuotaWidget();
private slots:
  // Network (KIO) slots
  void slotConnectionResult( int, const TQString& );
  void slotReceivedQuotaInfo( KMFolder*, KIO::Job*, const KMail::QuotaInfo& );


private:

  TQLabel* mLabel;
  KMail::QuotaWidget* mQuotaWidget;
  TQWidgetStack* mStack;
  ImapAccountBase* mImapAccount;
  TQString mImapPath;
  KMFolderDialog* mDlg;

  QuotaInfo mQuotaInfo;
  KMFolderType mFolderType;
};

} // end of namespace KMail

#endif /* FOLDERDIAQUOTA_H */

