/* This file is part of the KDE project
   Copyright (C) 2004 Mark Bucciarelli <mark@hubcapconsulting.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef _script_h_
#define _script_h_

//#include <tqvariant.h>
#include <tqobject.h>

class TQDir;
class TQProcess;
class TQString;
class TQStringList;

class Script : public TQObject
{
  Q_OBJECT
  TQ_OBJECT
public:
  Script( const TQDir& workingDirectory );
  virtual ~Script();
  void addArgument( const TQString &arg );
  void setTimeout( int seconds );
  int run();
private slots:
  void exit();
  void stderr();
  void stdout();
  void terminate();
private:
  TQProcess *m_proc;
  int m_status;
  bool m_stderr;
  int m_timeoutInSeconds;
};

#endif // _script_h_
