/*
    This file is part of Kandy.

    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include <tqlistview.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>

#include <kinputdialog.h>
#include <klocale.h>

#include "atcommand.h"

#include "cmdpropertiesdialog.h"
#include "cmdpropertiesdialog.moc"

class ParameterItem : public TQCheckListItem {
  public:
    ParameterItem(ATParameter *p,TQListView *parent) :
        TQCheckListItem(parent,p->name(),CheckBox),mParameter(p)
    {
      setText(1,p->value());
      setOn(p->userInput());
    }
        
    void writeParameter()
    {
      mParameter->setName(text(0));
      mParameter->setValue(text(1));
      mParameter->setUserInput(isOn());
    }
    
  private:
    ATParameter *mParameter;
};


/* 
 *  Constructs a CmdPropertiesDialog which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
CmdPropertiesDialog::CmdPropertiesDialog(ATCommand *cmd, TQWidget* parent,
                                         const char* name, bool modal,
                                         WFlags fl )
    : CmdPropertiesDialog_base( parent, name, modal, fl )
{
  mCmd = cmd;
  
  readCommand();
}

CmdPropertiesDialog::~CmdPropertiesDialog()
{
}

void CmdPropertiesDialog::readCommand()
{
  mNameEdit->setText(mCmd->cmdName());
  mStringEdit->setText(mCmd->cmdString());
  mHexCheck->setChecked(mCmd->hexOutput());

  TQPtrList<ATParameter> parameters = mCmd->parameters();
  for(int i=(int)parameters.count()-1;i>=0;--i) {
    ATParameter *p = parameters.at(i);
    new ParameterItem(p,mParameterList);
  }
}

void CmdPropertiesDialog::writeCommand()
{
  mCmd->setCmdName(mNameEdit->text());
  mCmd->setCmdString(mStringEdit->text());
  mCmd->setHexOutput(mHexCheck->isChecked());
  ParameterItem *item = (ParameterItem *)mParameterList->firstChild();
  while (item) {
    item->writeParameter();
    item = (ParameterItem *)item->nextSibling();
  }
}

void CmdPropertiesDialog::editParameterName(TQListViewItem *item)
{
  bool ok = false;

  TQString newName = KInputDialog::getText(TQString(),
                        i18n("Enter parameter name:"),item->text(0),&ok,this);

  if (ok) {
    item->setText(0,newName);
  }
}

void CmdPropertiesDialog::slotAccept()
{
  writeCommand();
  accept();
}
