#ifndef KADDRESSBOOKCARDVIEW_H
#define KADDRESSBOOKCARDVIEW_H

/*
    This file is part of KAddressBook.
    Copyright (c) 2002 Mike Pilone <mpilone@slac.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include <tqstring.h>
#include <kiconview.h>

#include "cardview.h"
#include "kaddressbookview.h"

class TQDragEntryEvent;
class TQDropEvent;
class KConfig;
class AddresseeCardView;

/**
  This view uses the CardView class to create a card view. At some
  point in the future I think this will be the default view of
  KAddressBook.
 */
class KAddressBookCardView : public KAddressBookView
{
  Q_OBJECT
  TQ_OBJECT

  public:
    KAddressBookCardView( KAB::Core *core, TQWidget *parent,
                          const char *name = 0 );
    virtual ~KAddressBookCardView();

    virtual TQStringList selectedUids();
    virtual TQString type() const { return "Card"; }
    virtual KABC::Field *sortField() const;

    virtual void readConfig( KConfig *config );
    virtual void writeConfig( KConfig *config );

    void scrollUp();
    void scrollDown();

  public slots:
    void refresh( const TQString &uid = TQString() );
    void setSelected( const TQString &uid = TQString(), bool selected = true );
    virtual void setFirstSelected( bool selected = true );

  protected slots:
    void addresseeExecuted( CardViewItem* );
    void addresseeSelected();
    void rmbClicked( CardViewItem*, const TQPoint& );

  private:
    AddresseeCardView *mCardView;
    bool mShowEmptyFields;
};

class AddresseeCardView : public CardView
{
  Q_OBJECT
  TQ_OBJECT
  public:
    AddresseeCardView( TQWidget *parent, const char *name = 0 );
    ~AddresseeCardView();

  signals:
    void startAddresseeDrag();
    void addresseeDropped( TQDropEvent* );

  protected:
    virtual void dragEnterEvent( TQDragEnterEvent* );
    virtual void dropEvent( TQDropEvent* );
    virtual void startDrag();
};

#endif
