
#include <tqvbox.h>
#include <tqpopupmenu.h>

#include <kaction.h>
#include <kstdaction.h>
#include <klocale.h>
#include <kmenubar.h>

#include "dccManager.h"
#include "dccToplevel.h"
#include "displayMgr.h"

extern DisplayMgr *displayMgr;

#define DTL_WINDOW_ID 10

dccTopLevel::dccTopLevel(TQWidget *parent, const char *name)
    : KMainWindow(parent, name, TQt::WDestructiveClose)
{
    m_mgr = new dccManager(this, TQCString(TQT_TQOBJECT(this)->name()) + "_dccManager");
//    m_mgr->show();
    setCentralWidget(m_mgr);

    connect(m_mgr, TQT_SIGNAL(changed(bool, TQString)), this, TQT_SIGNAL(changed(bool, TQString)));

    TQPopupMenu *win = new TQPopupMenu(this, TQCString(TQT_TQOBJECT(this)->name()) + "_popup_window");
    KAction *act = KStdAction::close(TQT_TQOBJECT(this), TQT_SLOT( close() ), actionCollection() );
    act->plug(win);

    menuBar()->insertItem(i18n("&File"), win, DTL_WINDOW_ID, -1);
    menuBar()->setAccel(Key_F, DTL_WINDOW_ID);


}

dccTopLevel::~dccTopLevel()
{
}

void dccTopLevel::close()
{

    displayMgr->hide(this);

}

#include "dccToplevel.moc"

