/*
 *
 *            kPPP: A pppd front end for the KDE project
 *
 *
 *            Copyright (C) 1997 Bernd Johannes Wuebben
 *                   wuebben@math.cornell.edu
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef _GENERAL_H_
#define _GENERAL_H_

#include <tqwidget.h>
#include <tqcombobox.h>
#include <tqlabel.h>
#include <tqcheckbox.h>
#include <tqgroupbox.h>
#include <tqpushbutton.h>
#include <kcolorbutton.h>

class TQSlider;
class KIntNumInput;
class ModemCommands;

class GeneralWidget : public TQWidget {
  Q_OBJECT
  TQ_OBJECT
public:
  GeneralWidget( TQWidget *parent=0, const char *name=0 );

private slots:
  void 	pppdtimeoutchanged(int);
  void 	caption_toggled(bool);
  void  iconify_toggled(bool on);
  void 	redial_toggled(bool on);
  void 	nocarrier_toggled(bool on);
  void 	xserver_toggled(bool on);
  void  quit_toggled(bool);
  void  docking_toggled(bool on);

};


class ModemWidget : public TQWidget {
  Q_OBJECT
  TQ_OBJECT
public:
  ModemWidget(TQWidget *parent=0, bool isnewmodem=true, const char *name=0);
	bool save();
	TQLineEdit *connectName() { return connectname_l;}
private slots:

private:
	TQLineEdit *connectname_l;
  TQLabel *connect_label;

  TQComboBox 	*enter;
  TQLabel 	*label1;
  TQLabel 	*label2;
  TQLabel 	*labeltmp;
  TQLabel 	*labelenter;
  TQComboBox 	*modemdevice;
  TQComboBox 	*flowcontrol;

  TQComboBox *baud_c;
  TQLabel *baud_label;

  KIntNumInput 	*modemtimeout;
  TQCheckBox     *modemlockfile;
  TQStringList    flowListItem;
};


class ModemWidget2 : public TQWidget {
  Q_OBJECT
  TQ_OBJECT
public:
  ModemWidget2(TQWidget *parent=0, const char *name=0);
	bool save();

private slots:
//  void 	use_cdline_toggled(bool);
  void 	modemcmdsbutton();
  void 	terminal();
  void 	query_modem();
 
private:
  TQLabel 	*labeltmp;
  TQPushButton 	*modemcmds;
  TQPushButton 	*modeminfo_button;
  TQPushButton 	*terminal_button;
  TQFrame 	*fline;
  TQCheckBox     *waitfordt;
  KIntNumInput 	*busywait;
  TQCheckBox 	*chkbox1;
  TQSlider       *volume;
	
	ModemCommands* mc;
};

class GraphSetup : public TQWidget {
  Q_OBJECT
  TQ_OBJECT
public:
  GraphSetup(TQWidget *parent = 0, const char *name = 0);

private slots:
  void enableToggled(bool);
  void colorChanged(const TQColor &);

private:
  void save();

  TQGroupBox *grpColor;
  TQCheckBox *enable_check;

  KColorButton *bg_color;
  KColorButton *text_color;
  KColorButton *in_color;
  KColorButton *out_color;

};

#endif


