/*
    YMSG - Yahoo Protocol Knetwork Bytestream

    Copyright (C) 2004 by Till Gerken <till@tantalo.net>

    Kopete (c) 2002-2004 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU General Public                   *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include <tqobject.h>
#include <kbufferedsocket.h>
#include <kdebug.h>
#include <kresolver.h>

#include "yahoobytestream.h"

KNetworkByteStream::KNetworkByteStream( TQObject *parent )
 : ByteStream ( parent )
{
	kdDebug( 14181 ) << "Instantiating new KNetwork byte stream." << endl;

	// reset close tracking flag
	mClosing = false;

	mSocket = new KNetwork::KBufferedSocket;

	// make sure we get a signal whenever there's data to be read
	mSocket->enableRead( true );

	// connect signals and slots
	TQObject::connect( mSocket, TQT_SIGNAL ( gotError ( int ) ), this, TQT_SLOT ( slotError ( int ) ) );
	TQObject::connect( mSocket, TQT_SIGNAL ( connected ( const KResolverEntry& ) ), this, TQT_SLOT ( slotConnected () ) );
	TQObject::connect( mSocket, TQT_SIGNAL ( closed () ), this, TQT_SLOT ( slotConnectionClosed () ) );
	TQObject::connect( mSocket, TQT_SIGNAL ( readyRead () ), this, TQT_SLOT ( slotReadyRead () ) );
	TQObject::connect( mSocket, TQT_SIGNAL ( bytesWritten ( int ) ), this, TQT_SLOT ( slotBytesWritten ( int ) ) );
}

bool KNetworkByteStream::connect( TQString host, TQString service )
{
	kdDebug( 14181 ) << "Connecting to " << host << ", service " << service << endl;

	return socket()->connect( host, service );
}

bool KNetworkByteStream::isOpen() const
{
	// determine if socket is open
	return socket()->isOpen();
}

void KNetworkByteStream::close ()
{
	kdDebug ( 14181 ) << "Closing stream." << endl;

	// close the socket and set flag that we are closing it ourselves
	mClosing = true;
	socket()->close();
}

int KNetworkByteStream::tryWrite ()
{
	// send all data from the buffers to the socket
	TQByteArray writeData = takeWrite();
	kdDebug( 14181 ) << "[writeData.size() = " << writeData.size() << "]" << endl;

	socket()->writeBlock( writeData.data(), writeData.size () );

	return writeData.size();
}

KNetwork::KBufferedSocket *KNetworkByteStream::socket() const
{
	return mSocket;
}

KNetworkByteStream::~KNetworkByteStream()
{
	delete mSocket;
}

void KNetworkByteStream::slotConnected()
{
	emit connected();
}

void KNetworkByteStream::slotConnectionClosed()
{
	kdDebug( 14181 ) << "Socket has been closed." << endl;

	// depending on who closed the socket, emit different signals
	if ( mClosing )
	{
		kdDebug( 14181 ) << "..by ourselves!" << endl;
		kdDebug( 14181 ) << "socket error is " << socket()->KSocketBase::errorString() << endl;
		emit connectionClosed ();
	}
	else
	{
		kdDebug( 14181 ) << "..by the other end" << endl;
		emit delayedCloseFinished ();
	}
}

void KNetworkByteStream::slotReadyRead()
{
	kdDebug( 14181 );
	// stuff all available data into our buffers
	TQByteArray readBuffer;
	readBuffer.resize( socket()->bytesAvailable () );

	socket()->readBlock( readBuffer.data (), readBuffer.size () );

	appendRead( readBuffer );

	emit readyRead();
}

void KNetworkByteStream::slotBytesWritten( int bytes )
{
	kdDebug( 14181 ) << "[int bytes]: " << bytes << endl;
	emit bytesWritten(bytes);
}

void KNetworkByteStream::slotError( int code )
{
	kdDebug( 14181 ) << "Socket error " << code << endl;

	emit error( code );
}

#include "yahoobytestream.moc"

// kate: indent-width 4; replace-tabs off; tab-width 4; space-indent off;
