/*
 * cipher.h - Simple wrapper to 3DES,AES128/256 CBC ciphers
 * Copyright (C) 2003  Justin Karneges
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef CS_CIPHER_H
#define CS_CIPHER_H

#include<tqstring.h>
#include<tqcstring.h>

namespace Cipher
{
	enum Type { None, TripleDES, AES_128, AES_256 };

	class Key
	{
	public:
		Key() { v_type = None; }

		bool isValid() const { return (v_type == None ? false: true); }
		void setType(Type x) { v_type = x; }
		Type type() const { return v_type; }
		void setData(const TQByteArray &d) { v_data = d; }
		const TQByteArray & data() const { return v_data; }

	private:
		Type v_type;
		TQByteArray v_data;
	};

	Key generateKey(Type);
	TQByteArray generateIV(Type);
	int ivSize(Type);
	TQByteArray encrypt(const TQByteArray &, const Key &, const TQByteArray &iv, bool pad, bool *ok=0);
	TQByteArray decrypt(const TQByteArray &, const Key &, const TQByteArray &iv, bool pad, bool *ok=0);
}

class RSAKey
{
public:
	RSAKey();
	RSAKey(const RSAKey &);
	RSAKey & operator=(const RSAKey &);
	~RSAKey();

	bool isNull() const;
	void *data() const;
	void setData(void *);

private:
	class Private;
	Private *d;

	void free();
};

RSAKey generateRSAKey();
TQByteArray encryptRSA(const TQByteArray &buf, const RSAKey &key, bool *ok=0);
TQByteArray decryptRSA(const TQByteArray &buf, const RSAKey &key, bool *ok=0);
TQByteArray encryptRSA2(const TQByteArray &buf, const RSAKey &key, bool *ok=0);
TQByteArray decryptRSA2(const TQByteArray &buf, const RSAKey &key, bool *ok=0);

#endif
