
#ifndef _K_SSL_SOCKET_H_
#define _K_SSL_SOCKET_H_

/*
    ksslsocket.h - KDE SSL Socket

    Copyright (c) 2005      by Tommi Rantala <tommi.rantala@cs.helsinki.fi>
    Copyright (c) 2004      by Jason Keirstead <jason@keirstead.org>

    Kopete    (c) 2002-2005 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <tqvariant.h>
#include <kextsock.h>
#include <kio/slavebase.h>

class KSSLSocketPrivate;

class KSSLSocket : public KExtendedSocket
{
	Q_OBJECT
  TQ_OBJECT

	public:
		KSSLSocket();
		~KSSLSocket();

		TQ_LONG readBlock( char* data, TQ_ULONG maxLen );
		TQ_LONG writeBlock( const char* data, TQ_ULONG len );
		int peekBlock( char *data, uint maxLen );
#ifdef USE_QT4
		qint64 bytesAvailable() const;
#else // USE_QT4
		int bytesAvailable() const;
#endif // USE_QT4

		void showInfoDialog();

	signals:
		void sslFailure();
		void certificateAccepted();
		void certificateRejected();

	private slots:
		void slotConnected();
		void slotDisconnected();
		void slotReadData();

	private:
		int verifyCertificate();
		int messageBox( KIO::SlaveBase::MessageBoxType type, const TQString &text,
			const TQString &caption,	const TQString &buttonYes, const TQString &buttonNo );


		//Copied frm tcpslavebase to simply integrating their dialog function
		void setMetaData( const TQString &, const TQVariant & );
		bool hasMetaData( const TQString & );
		TQString metaData( const TQString & );

		KSSLSocketPrivate *d;
};

#endif
