/*
    ircusercontact.h - IRC User Contact

    Copyright (c) 2002      by Nick Betcher <nbetcher@kde.org>
    Copyright (c) 2003      by Jason Keirstead <jason@keirstead.org

    Kopete    (c) 2002      by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef IRCUSERCONTACT_H
#define IRCUSERCONTACT_H

#include "kopetechatsessionmanager.h"
#include "irccontact.h"
#include "kopeteonlinestatus.h"

class TQTimer;

class KActionCollection;
class KAction;
class KActionMenu;
class KCodecAction;

class IRCContactManager;
class IRCChannelContact;

struct IRCUserInfo
{
	TQString userName;
	TQString hostName;
	TQString realName;
	TQString serverName;
	TQString serverInfo;
	TQString flags;
	TQStringList channels;
	unsigned long idle;
	bool isOperator;
	bool isIdentified;
	bool away;
	bool online;
	uint hops;
	TQDateTime lastOnline;
	TQTime lastUpdate;
};

/**
 * @author Jason Keirstead <jason@keirstead.org
 *
 * This class is the @ref Kopete::Contact object representing IRC Users, not channels.
 * It is derrived from IRCContact where much of its functionality is shared with @ref IRCChannelContact.
 */
class IRCUserContact : public IRCContact
{
	Q_OBJECT
  TQ_OBJECT

public:
	// This class provides a Kopete::Contact for each user on the channel.
	IRCUserContact(IRCContactManager *, const TQString &nickname, Kopete::MetaContact *mc);

	// Kopete::Contact stuff
	virtual TQPtrList<KAction> *customContextMenuActions( Kopete::ChatSession *manager );
	virtual const TQString caption() const;

	void setAway(bool isAway);

	TQString formattedName() const;

	//Methods handled by the signal mapper
	void incomingUserIsAway(const TQString &message );
	void userOnline();
	void newAction( const TQString &from, const TQString &action );
	void newWhoIsUser(const TQString &username, const TQString &hostname, const TQString &realname);
	void newWhoIsServer(const TQString &server, const TQString &serverInfo);
	void newWhoIsOperator();
	void newWhoIsIdentified();
	void newWhoIsIdle(unsigned long seconds);
	void newWhoIsChannels(const TQString &channel);
	void whoIsComplete();
	void whoWasComplete();
	void newWhoReply( const TQString &channel, const TQString &user, const TQString &host,
		const TQString &server, bool away, const TQString &flags, uint hops,
		const TQString &realName );

public slots:
	/** \brief Updates online status for channels based on current internal status.
	 */
	virtual void updateStatus();

	virtual void sendFile(const KURL &sourceURL, const TQString&, unsigned int);

protected slots:
	virtual void privateMessage(IRCContact *from, IRCContact *to, const TQString &message);

private slots:
	void slotOp();
	void slotDeop();
	void slotVoice();
	void slotDevoice();
	void slotCtcpPing();
	void slotCtcpVersion();
	void slotBanHost();
	void slotBanUserHost();
	void slotBanDomain();
	void slotBanUserDomain();
	void slotKick();
	void slotUserOffline();

	void slotBanHostOnce();
	void slotBanUserHostOnce();
	void slotBanDomainOnce();
	void slotBanUserDomainOnce();

	virtual void slotUserInfo();

	//This can't be handled by the contact manager since
	void slotIncomingModeChange(const TQString &nick, const TQString &channel, const TQString &mode);

private:
	enum bitAdjustment { RemoveBits, AddBits };
	void adjustInternalOnlineStatusBits(IRCChannelContact *channel, unsigned statusAdjustment, bitAdjustment adj);

	void contactMode(const TQString &mode);
	void updateInfo();

	KActionMenu *actionModeMenu;
	KActionMenu *actionCtcpMenu;
	KAction *actionKick;
	KActionMenu *actionBanMenu;
	KCodecAction *codecAction;
	Kopete::ChatSession *mActiveManager;
	TQTimer *mOnlineTimer;
	IRCUserInfo mInfo;
};

#endif

// vim: set noet ts=4 sts=4 tw=4:
