/*
    latexplugin.h

    Kopete Latex Plugin

    Copyright (c) 2004 by Duncan Mac-Vicar Prett   <duncan@kde.org>
    Copyright (c) 2004-2005 by Olivier Goffart  <ogoffart@kde. org>

    Kopete    (c) 2001-2004 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef LATEXPLUGIN_H
#define LATEXPLUGIN_H

#include <tqobject.h>
#include <tqstring.h>

#include <ktempfile.h>

#include "kopetemessage.h"
#include "kopeteplugin.h"

class TQStringList;
class TQString;


namespace Kopete { class Message; class ChatSession; }

/**
  * @author Duncan Mac-Vicar Prett
  */

class LatexPlugin : public Kopete::Plugin
{
	Q_OBJECT
  TQ_OBJECT

public:
	static LatexPlugin  *plugin();

	LatexPlugin( TQObject *parent, const char *name, const TQStringList &args );
	~LatexPlugin();

public slots:
	void slotSettingsChanged();
	void slotMessageAboutToShow( Kopete::Message& msg );
	void slotMessageAboutToSend( Kopete::Message& msg );
	void slotNewChatSession( Kopete::ChatSession *KMM);

public:
	/**
	 * gives a latex formula, and return the filename of the file where the latex is stored.
     */
	TQString handleLatex(const TQString &latex);

	/**
	 * return false if the latex formula may contains malicious commands
	 */
	bool securityCheck(const TQString & formula);


private:
	static LatexPlugin* s_pluginStatic;
	TQString m_convScript;
	bool mMagickNotFoundShown;
	TQPtrList<KTempFile> m_tempFiles;
};

#endif
