/*  This file is part of the KDE project
    Copyright (C) 2003 Olivier Goffart <ogoffart @ kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/

#include "kcautoconfigmodule.h"

#include <tqlayout.h>

#include <kautoconfig.h>

class KCAutoConfigModule::KCAutoConfigModulePrivate
{
	public:
	KAutoConfig *kautoconfig;
};


KCAutoConfigModule::KCAutoConfigModule( TQWidget * parent, const char * name, const TQStringList & args )
		: KCModule( parent, name, args )
		, d( new KCAutoConfigModulePrivate )
{
	d->kautoconfig = new KAutoConfig( TQT_TQOBJECT(this) );
	connect(d->kautoconfig, TQT_SIGNAL(widgetModified()), TQT_SLOT(slotWidgetModified()));
	connect(d->kautoconfig, TQT_SIGNAL(settingsChanged()), TQT_SLOT(widgetModified()));
}

KCAutoConfigModule::KCAutoConfigModule( KInstance * instance, TQWidget * parent, const TQStringList & args )
    : KCModule( instance, parent, args )
    , d( new KCAutoConfigModulePrivate )
{
	d->kautoconfig = new KAutoConfig( TQT_TQOBJECT(this) );
	connect(d->kautoconfig, TQT_SIGNAL(widgetModified()), TQT_SLOT(slotWidgetModified()));
	connect(d->kautoconfig, TQT_SIGNAL(settingsChanged()), TQT_SLOT(slotWidgetModified()));
}



KCAutoConfigModule::KCAutoConfigModule( KConfig *config,TQWidget * parent, const char * name, const TQStringList & args )
		: KCModule( parent, name, args )    , d( new KCAutoConfigModulePrivate )
{
	d->kautoconfig = new KAutoConfig( config, TQT_TQOBJECT(this) );
	connect(d->kautoconfig, TQT_SIGNAL(widgetModified()), TQT_SLOT(slotWidgetModified()));
	connect(d->kautoconfig, TQT_SIGNAL(settingsChanged()), TQT_SLOT(slotWidgetModified()));
}

KCAutoConfigModule::KCAutoConfigModule( KConfig *config , KInstance * instance, TQWidget * parent, const TQStringList & args )
    : KCModule( instance, parent, args )
    , d( new KCAutoConfigModulePrivate )
{
	d->kautoconfig = new KAutoConfig( config, TQT_TQOBJECT(this) );
	connect(d->kautoconfig, TQT_SIGNAL(widgetModified()), TQT_SLOT(slotWidgetModified()));
	connect(d->kautoconfig, TQT_SIGNAL(settingsChanged()), TQT_SLOT(slotWidgetModified()));
}


KCAutoConfigModule::~KCAutoConfigModule()
{
	delete d;
}


void KCAutoConfigModule::load()
{
	d->kautoconfig->reloadSettings();
}

void KCAutoConfigModule::save()
{
    d->kautoconfig->saveSettings();
}

void KCAutoConfigModule::defaults()
{
    d->kautoconfig->resetSettings();
}

void KCAutoConfigModule::slotWidgetModified()
{
    emit changed(d->kautoconfig->hasChanged());
}

KAutoConfig *KCAutoConfigModule::autoConfig()
{
	return d->kautoconfig;
}

void KCAutoConfigModule::setMainWidget(TQWidget *widget, const TQString& group )
{
	TQBoxLayout * l = new TQVBoxLayout( this );
	l->addWidget( widget );

	d->kautoconfig->addWidget(widget,group);
	d->kautoconfig->retrieveSettings(true);
}

#include "kcautoconfigmodule.moc"

// vim: sw=4 sts=4 et

