/*
    kopeteiface.h - Kopete DCOP Interface

    Copyright (c) 2002 by Hendrik vom Lehn       <hennevl@hennevl.de>

    Kopete    (c) 2002-2003      by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KopeteIface_h
#define KopeteIface_h

#include <dcopobject.h>
#include <tqstringlist.h>
#include <kurl.h>

#include "kopeteonlinestatus.h"

/**
 * DCOP interface for kopete
 */
class KopeteIface : virtual public DCOPObject
{
	K_DCOP

public:
	KopeteIface();

k_dcop:
	TQStringList contacts();
	TQStringList reachableContacts();
	TQStringList onlineContacts();
	TQStringList fileTransferContacts();
	TQStringList contactFileProtocols(const TQString &displayName);

	/*void sendFile(const TQString &displayName, const KURL &sourceURL,
		const TQString &altFileName = TQString(), uint fileSize = 0);*/

	// FIXME: Do we *need* this one? Sounds error prone to me, because
	// nicknames can contain parentheses too.
	// Better add a contactStatus( const TQString id ) I'd say - Martijn
	TQStringList contactsStatus();

	/**
	 * Open a chat to a contact, and optionally set some initial text
	 */
	TQString messageContact( const TQString &contactId, const TQString &messageText = TQString() );

	/**
	 * Describe the status of a contact by their metaContactId,
	 * aka their uid in KABC.
	 */
	TQString onlineStatus( const TQString &metaContactId );

	/**
	 * Message a contact by their metaContactId, aka their uid in KABC.
	 */
	void messageContactById( const TQString &metaContactId );

	/**
	 * Adds a contact with the specified params.
	 *
	 * @param protocolName The name of the protocol this contact is for ("ICQ", etc)
	 * @param accountId The account ID to add the contact to
	 * @param contactId The unique ID for this protocol
	 * @param displayName The displayName of the contact (may equal userId for some protocols
	 * @param groupName The name of the group to add the contact to
	 * @return Weather or not the contact was added successfully
	 */
	bool addContact( const TQString &protocolName, const TQString &accountId, const TQString &contactId,
		const TQString &displayName, const TQString &groupName = TQString() );

	/**
	 * return a list of alls accounts.
	 * form: XXXProtocol||AccountId
	 */
	TQStringList accounts();

	/**
	 * connect a given account in the given protocol
	 */
	void connect(const TQString &protocolName, const TQString &accountId);
	/**
	 * disconnect a given account in the given protocol
	 */
	void disconnect(const TQString &protocolName, const TQString &accountId);

	/**
	 * Ask all accounts to connect
	 */
	void connectAll();

	/**
	 * Ask all accounts to disconnect
	 */
	void disconnectAll();

	/**
	 * load a plugin
	 * the name is the name of the library: example: kopete_msn
	 * but you can ommit the kopete_ prefix
	 */
	bool loadPlugin( const TQString& name );
	/**
	 * unload a plugin
	 * the name is the name of the library: example: kopete_msn
	 * but you can ommit the kopete_ prefix
	 */
	bool unloadPlugin( const TQString& name );

	/**
	 * set all account away using the global away function
	 */
	void setAway();

	/**
	 * set all account away using the global away function
	 * and set an away message
	 */
	void setAway( const TQString &msg ) { setAway( msg, true ); }

	/**
	 * set all account away using the global away function
	 * and set an away message.
	 * @param away decides if the message is away/non-away
	 */
	void setAway( const TQString &msg, bool away );

	/**
	 * set Available all accountes
	 */
	void setAvailable();
	/**
	 * set all account away using the auto away funciton.
	 * accounts will return online if activity is detected again
	 */
	void setAutoAway();

	/**
	 * set the global nickname if global identity is enabled.
	 * @param nickname the new global nickname
	 */
	void setGlobalNickname( const TQString &nickname );

	/**
	 * set the global photo if global identity is enabled.
	 * @param photoUrl URL to the photo
	 */
	void setGlobalPhoto( const KURL &photoUrl );
    
    /**
     * get the contactIds for a given display name
     * @param displayName
     */
    TQStringList contactsForDisplayName( const TQString & displayName );

    /**
     * get the metacontactIds that have the given contactId
     * @param contactId
     */
    TQStringList metacontactsForContactId( const TQString & contactId );
};

#endif



/*
 * Local variables:
 * c-indentation-style: k&r
 * c-basic-offset: 8
 * indent-tabs-mode: t
 * End:
 */
// vim: set noet ts=4 sts=4 sw=4:

