/*
 * xmlnewsaccess.h
 *
 * Copyright (c) 2001 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#ifndef XMLNEWSACCESS_H
#define XMLNEWSACCESS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqvaluelist.h>
#include <tqobject.h>

#include <kio/job.h>
#include <kurl.h>

class TQBuffer;
class TQDomDocument;
class XMLNewsSource;

class XMLNewsArticle
{
	public:
		typedef TQValueList<XMLNewsArticle> List;
		
		XMLNewsArticle() {}
		XMLNewsArticle(const TQString &headline, const KURL &addresss);
		XMLNewsArticle(const XMLNewsArticle &other) { (*this) = other; }
		XMLNewsArticle &operator=(const XMLNewsArticle &other);

		TQString headline() const { return m_headline; }
		void setHeadline(const TQString &headline) { m_headline = headline; }

		KURL address() const { return m_address; }
		void setAddress(const KURL &address) { m_address = address; }

		bool operator== (const XMLNewsArticle &a);
		bool operator!= (const XMLNewsArticle &a) { return !operator==(a); }

	private:
		TQString        m_headline;
		KURL           m_address;
};

class XMLNewsSource : public TQObject
{
	Q_OBJECT
  TQ_OBJECT
		
	public:
		XMLNewsSource();
		virtual ~XMLNewsSource();

		void loadFrom(const KURL &);

		virtual TQString newsSourceName() const { return m_name; }
		virtual TQString link() const { return m_link; }
		virtual TQString description() const { return m_description; }
		const XMLNewsArticle::List &articles() const { return m_articles; }

	signals:
		void loadComplete(XMLNewsSource *, bool);
	
	protected:
		void processData(const TQByteArray &, bool = true);
		
		TQString m_name;
		TQString m_link;
		TQString m_description;

	private slots:
		void slotData(KIO::Job *, const TQByteArray &);
		void slotResult(KIO::Job *);
	
	private:
		XMLNewsArticle::List m_articles;
		TQBuffer             *m_downloadData;
};

#endif // XMLNEWSACCESS_H
