/***************************************************************************
*                                transferlist.h
*                             -------------------
*
*    Revision     : $Id$
*    begin        : Tue Jan 29 2002
*    copyright    : (C) 2002 by Patrick Charbonnier
*                 : Based On Caitoo v.0.7.3 (c) 1998 - 2000, Matej Koss
*    email        : pch@freeshell.org
*
****************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 ***************************************************************************/

#ifndef _TransferList_h
#define _TransferList_h

#include <klistview.h>
#include <tqptrlist.h>

#include <kurl.h>

class Transfer;

class TransferIterator:public TQListViewItemIterator
{

public:

    TransferIterator(TQListView * view):TQListViewItemIterator(view)
    {
    }
    Transfer *current() const
    {
        return (Transfer *) TQListViewItemIterator::current();
    }
    void reset()
    {
        curr = listView->firstChild();
    }

};


class TransferList:public KListView
{
  Q_OBJECT
  TQ_OBJECT
public:


    TransferList(TQWidget * parent = 0, const char *name = 0);
    virtual ~ TransferList();

    Transfer *addTransfer(const KURL & _source, const KURL & _dest,
                          bool canShow = true );

    virtual void setSelected(TQListViewItem * item, bool selected);

    void moveToBegin(Transfer * item);
    void moveToEnd(Transfer * item);

    uint getPhasesNum()const
    {
        return phasesNum;
    }
    bool updateStatus(int counter);
    Transfer * find(const KURL& _src);
    bool areTransfersQueuedOrScheduled();

    void readTransfers(const KURL& file);
    void writeTransfers(const TQString& file);

    friend class Transfer;

signals:
    void transferSelected(Transfer * item);
    void popupMenu(Transfer * item);

protected slots:
    void slotTransferSelected(TQListViewItem * item);
    void slotPopupMenu(TQListViewItem * item);

protected:

    void readConfig();
    void writeConfig();

    // ListView IDs
    int lv_pixmap, lv_filename, lv_resume, lv_count, lv_progress;
    int lv_total, lv_speed, lv_remaining, lv_url;

    TQPtrList < TQPixmap > animConn;
    TQPtrList < TQPixmap > animTry;
    TQPixmap pixQueued;
    TQPixmap pixScheduled;
    TQPixmap pixDelayed;
    TQPixmap pixFinished;
    TQPixmap pixRetrying;

    uint phasesNum;
    uint jobid;
};


#endif                          // _TransferList_h
