/**************************************************************************

    klcdnumber.h  - The KLCDNumber widget (displays a lcd number)
    Copyright (C) 1998  Antonio Larrosa Jimenez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    Send comments and bug fixes to larrosa@kde.org
    or to Antonio Larrosa, Rio Arnoya, 10 5B, 29006 Malaga, Spain

***************************************************************************/
#ifndef _klcdnumber_h_
#define _klcdnumber_h_

#include <tqwidget.h>

class TQPainter;
class KTriangleButton;
class TQColor;

class KLCDNumber : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT
protected:
    class digit {
public:
        digit()
         : up(false), nw(false), ne(false), md(false), 
           sw(false), se(false), bt(false) { } 
        digit( bool _up, bool _nw, bool _ne, 
               bool _md, bool _sw, bool _se, bool _bt)
         : up(_up), nw(_nw), ne(_ne), md(_md), 
           sw(_sw), se(_se), bt(_bt) { } 
        bool up;  
        bool nw;  
        bool ne;
        bool md;
        bool sw;
        bool se;
        bool bt;
    };
    /*
        up
        ---
     nw|   |ne
       |___|<------ md
       |   |
     sw|___|se
        bt
     */
    

    KLCDNumber::digit Digit[11];
/*
={
        / 0 /    {true,true,true,false,true,true,true},
        / 1 /    {false,false,true,false,false,true,false},
        / 2 /    {true,false,true,true,true,false,true},
        / 3 /    {true,false,true,true,false,true,true},
        / 4 /    {false,true,true,true,false,true,false},
        / 5 /    {true,true,false,true,false,true,true},
        / 6 /    {true,true,false,true,true,true,true},
        / 7 /    {true,false,true,false,false,true,false},
        / 8 /    {true,true,true,true,true,true,true},
        / 9 /    {true,true,true,true,false,true,true},
        /   /    {false,false,false,false,false,false,false}
    };*/
    
    int numDigits;
    bool setUserChangeValue;
    bool setUserDefaultValue;
    bool doubleclicked;

    TQColor backgcolor;
    TQColor LCDcolor;
    
    double value;
    double oldvalue;
    double defaultValue;

    double minValue;
    double maxValue;

    void drawVerticalBar(TQPainter *qpaint,int x,int y,int w,int h,int d);
    void drawHorizBar(TQPainter *qpaint,int x,int y,int w,int h,int d);
    void drawDigit(TQPainter *qpaint,int x,int y,int w,int h,digit d);

    void initDigits(void);

public:
    KLCDNumber(int _numDigits,TQWidget *parent,const char *name);
    KLCDNumber(bool _setUserChangeValue,int _numDigits,TQWidget *parent,const char *name);

    void setUserSetDefaultValue(bool _userSetDefaultValue);
    void setDefaultValue(double v);
    
    void setValue(double v);
    double getValue(void) { return value; };
    double getOldValue(void) { return oldvalue; };

    double getMinValue(void) { return minValue;};
    double getMaxValue(void) { return maxValue;};
    void setRange(double min, double max);

    void setLCDBackgroundColor (int r,int g,int b);
    void setLCDColor (int r,int g,int b);

    void display (int v);
    void display (double v);

    TQSize sizeHint ();
//    TQSizePolicy sizePolicy();

protected:

    virtual void paintEvent ( TQPaintEvent *e );
    virtual void resizeEvent ( TQResizeEvent *e);
    virtual void mouseDoubleClickEvent (TQMouseEvent *e);
    virtual void mousePressEvent (TQMouseEvent *e);
    virtual void timerEvent(TQTimerEvent *e);
    void defaultValueClicked();
    
    KTriangleButton *downBtn;
    KTriangleButton *upBtn;


    
public slots:

    void decreaseValue();
    void increaseValue();
    void decreaseValueFast();
    void increaseValueFast();

signals:

    void valueChanged(double v);
    
};

#endif
