/***************************************************************************
                          lskatview.cpp  -  description
                             -------------------
    begin                : Tue May  2 15:47:11 CEST 2000
    copyright            : (C) 2000 by Martin Heni
    email                : martin@heni-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for TQt
#include <tqpixmap.h>
#include <tqcolor.h>
#include <tqrect.h>
#include <tqfontmetrics.h>
#include <tqpoint.h>
#include <tqstring.h>
#include <tqpainter.h>
#include <tqdatetime.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <klocale.h>
#include <math.h>
#include <stdio.h>
#include <kglobalsettings.h>


// application specific includes
#include "lskatview.h"
#include "lskatdoc.h"
#include "lskat.h"
#include "KEInput.h"
#include "KEMessage.h"

#define CARD_X_OFFSET 32   // offset fromleft side
#define CARD_Y_OFFSET 5   // offset from top
#define CARD_X_SPACE  10   // space between cards
#define CARD_Y_SPACE  5   // space between cards
#define CARD_Y_BOARD_OFFSET 20  // space between players

#define CARD_X_DECK   5    // shift deck and card
#define CARD_Y_DECK   3    // shift deck and card

#define CARD_X_MOVE1  430  // positon of first moved card
#define CARD_Y_MOVE1  140
#define CARD_X_MOVE2  450  // psoiton of second moved card
#define CARD_Y_MOVE2  190

// Probably most unnecessary and unused now
#define STATUS_X0     15   // pos in status win
#define STATUS_X1     60
#define STATUS_X2     100
#define STATUS_Y0     26
#define STATUS_Y1     44
#define STATUS_Y2     62
#define STATUS_Y3     80
#define STATUS_XT     128
#define STATUS_YT     47
#define STATUS_XTYPE  135
#define STATUS_YTYPE  12

#define FINAL_XT1     15
#define FINAL_XT2     -55
#define FINAL_YT      15

#define FINAL_X0      140
#define FINAL_Y0      35

#define FINAL_X1      110
#define FINAL_Y1      90

#define FINAL_X2      130
#define FINAL_Y2      65

#define FINAL_X3      30
#define FINAL_X4      90
#define FINAL_X5      170
#define FINAL_X6      230

#define FINAL_Y3      95
#define FINAL_Y4      125

#define FINAL_X7      30
#define FINAL_Y7      155

//#define COL_STATUSLIGHT  white
#define COL_STATUSBORDER black
//#define COL_STATUSFIELD  TQColor(192,192,192)
//#define COL_STATUSDARK   TQColor(65,65,65)
#define COL_STATUSFIELD  TQColor(130,130,255)
#define COL_STATUSDARK   TQColor(0,0,65)
#define COL_STATUSLIGHT  TQColor(210,210,255)
#define COL_PLAYER       TQColor(255,255,0)

#define DLGBOXTITLE  TITLE

#define MOVECOUNTER  20      // so many moves when playing card
#define MOVE_TIMER_DELAY 7   // timer in milllisec default 7

LSkatView::LSkatView(TQWidget *parent, const char *name) : TQWidget(parent, name)
{
  setBackgroundMode(PaletteBase);
  // setBackgroundMode(NoBackground);

  status_rect1=TQRect(412,CARD_Y_OFFSET+5,180,95+25);
  status_rect2=TQRect(412,310,180,95+25);
  status_rect3=TQRect(CARD_X_OFFSET+60,CARD_Y_OFFSET+5+100+15+20,
                     400,320-100-CARD_Y_OFFSET-30);

  setBackgroundColor(TQColor(0,0,128));
  setBackgroundPixmap( getDocument()->mPixBackground );

  moveTimer=new TQTimer(this);
  moveTimer->stop();
  connect(moveTimer,TQT_SIGNAL(timeout()),this,TQT_SLOT(moveTimerReady()));

  introcnt=0;
  introTimer=new TQTimer(this);
  introTimer->stop();
  connect(introTimer,TQT_SIGNAL(timeout()),this,TQT_SLOT(introTimerReady()));
  introTimer->start(75,FALSE);

  for (int i=0;i<NO_OF_CARDS;i++)
  {
    introCards[i]=getDocument()->random(NO_OF_CARDS);
  }
}

// Access the document with the game data
LSkatDoc *LSkatView::getDocument() const
{
  LSkatApp *theApp=(LSkatApp *) parentWidget();
  return theApp->getDocument();
}

// draw a border around a rect
// p: Painter
// rect: The rect to draw a border
// offset: An offset to the rect to make it smaller
// width: The width of the border
// mode: 0: Light border, 1: dark border
void LSkatView::drawBorder(TQPainter *p,TQRect rect,int offset,int width,int mode)
{
TQPen graypen;
int i;
TQPoint p1,p2;

	if (mode!=0 && mode!=1) return;

	p1=rect.topLeft();
	p2=rect.bottomRight();

	if (mode==0) p->setPen(COL_STATUSLIGHT);
	else if (mode==1) p->setPen(COL_STATUSDARK);

	for (i=0;i<width;i++)
	{
		p->moveTo(p1.x()+offset+i,p2.y()-offset-i);
		p->lineTo(p1.x()+offset+i,p1.y()+offset+i);
		p->lineTo(p2.x()-offset-i,p1.y()+offset+i);
	}
	if (mode==1) p->setPen(COL_STATUSLIGHT);
	else if (mode==0) p->setPen(COL_STATUSDARK);
	for (i=0;i<width;i++)
	{
		p->moveTo(p1.x()+offset+i,p2.y()-offset-i);
		p->lineTo(p2.x()-offset-i,p2.y()-offset-i);
		p->lineTo(p2.x()-offset-i,p1.y()+offset+i);
	}
}

// draw a move by animating the movment and turning of the
// card. This is called until the card reaches its final
// position
void LSkatView::drawMove(TQPainter *p)
{
  int m1,m2;
  int below;
  TQPoint point1,point2;

  m1=getDocument()->GetMove(0);
  m2=getDocument()->GetMove(1);
  point1=TQPoint(CARD_X_MOVE1,CARD_Y_MOVE1);
  point2=TQPoint(CARD_X_MOVE2,CARD_Y_MOVE2);

  below=getDocument()->GetLastStartPlayer();
  if (below<0) below=getDocument()->GetStartPlayer();

  if (below==0)
  {
    if (m1>=0) p->drawPixmap(point1,getDocument()->mPixCard[m1]);
    if (m2>=0) p->drawPixmap(point2,getDocument()->mPixCard[m2]);
  }
  else
  {
    if (m2>=0) p->drawPixmap(point2,getDocument()->mPixCard[m2]);
    if (m1>=0) p->drawPixmap(point1,getDocument()->mPixCard[m1]);
  }

  int card;
  TQPoint point;
  card=getDocument()->GetMoveStatus();
  if (card>=0)
  {

    if (cardmoveunder>=0)
    {
      // turn new card
      if ((double)cardmovecnt/(double)MOVECOUNTER>0.5)
      {
        TQPixmap pix1(getDocument()->mPixCard[cardmoveunder]);
        int wid=pix1.width();
        TQWMatrix m;
        m.scale(2.0*((double)cardmovecnt/(double)MOVECOUNTER-0.5),1.0);
        pix1=pix1.xForm(m);
        point=TQPoint((wid-pix1.width())/2,0);
        p->drawPixmap(cardorigin+point,pix1);
      }
      // turn deck
      else
      {
        TQPixmap pix1(getDocument()->mPixDeck);
        int wid=pix1.width();
        TQWMatrix m;
        m.scale(1.0-2.0*((double)cardmovecnt/(double)MOVECOUNTER),1.0);
        pix1=pix1.xForm(m);
        point=TQPoint((wid-pix1.width())/2,0);
        p->drawPixmap(cardorigin+point,pix1);
      }
    } /* end turn card */

    point=cardorigin+(cardend-cardorigin)*cardmovecnt/MOVECOUNTER;
    p->drawPixmap(point,getDocument()->mPixCard[card]);

  }
}

// Show the intro (Cards+Text)
// This is called repeatetly
void LSkatView::drawIntro(TQPainter *p)
{
    int i,c1,c2,x,cnt,y,col,col2,col3,col4;
    // The window width;
    // int win_width = p->window().width();
    TQPoint point,point1,p2;
    TQString s;
    // Get a nice font
    TQFont font = KGlobalSettings::generalFont();
    font.setPointSize(48);
    // Get the font info to determine text sizes
    TQFontMetrics fontMetrics(font);

    p->setFont(font);

    cnt=introcnt;
    if (cnt>NO_OF_CARDS) cnt=NO_OF_CARDS;


    i=0;
    point=TQPoint(20,20);
    point1=TQPoint(550,20);

    for (i=0;i<cnt;i++)
    {
      x=(int)((i+10)*5*sin(1.5*i*M_PI/(float)NO_OF_CARDS));
      c1=introCards[i];
      c2=introCards[(i+17)%NO_OF_CARDS];
      p2=TQPoint(i*10+x, i*10);
      p->drawPixmap(point+p2,getDocument()->mPixCard[c1]);
      p2=TQPoint(-i*10-x, i*10);
      p->drawPixmap(point1+p2,getDocument()->mPixCard[c2]);
    }

    // All text are positioned that they end up at x=310-textwidth/2
    // All texts are drawn twice with different colors to produce a shadow
    col=255-8*i;
    if (col<0) col=0;
    col2=2*col/3;
    col3=255-2*i;
    col4=2*col3/3;
    s=i18n("Lieutenant Skat");
    x=310-fontMetrics.width(s)/2;
    y=-20+(int)(200.0*sin(0.5*M_PI/(float)NO_OF_CARDS*cnt));
    p->setPen(TQColor(col4,col2,0));
    p->drawText(x-2,y+2,s);

    p->setPen(TQColor(col3,col,0));
    p->drawText(x,y,s);

    s=i18n("for");
    y=270+(NO_OF_CARDS-cnt)*3;
    x=-fontMetrics.width(s)/2+(int)(310.0*sin(0.5*M_PI/(float)NO_OF_CARDS*cnt));
    p->setPen(TQColor(col4,col2,0));
    p->drawText(x-2,y+2,s);

    p->setPen(TQColor(col3,col,0));
    p->drawText(x,y,s);

    s=i18n("T D E");
    y=350+(NO_OF_CARDS-cnt)*3;
    // x=640-(int)(380.0*sin(0.5*M_PI/(float)NO_OF_CARDS*cnt));
    x=570-fontMetrics.width(s)/2-(int)(260.0*sin(0.5*M_PI/(float)NO_OF_CARDS*cnt));
    p->setPen(TQColor(col4,col2,0));
    p->drawText(x-2,y+2,s);

    p->setPen(TQColor(col3,col,0));
    p->drawText(x,y,s);
}

// Draw all cards to create the game board
void LSkatView::drawDeck(TQPainter *p)
{
  int x,y,card;
  int player,pos,height;
  TQPoint point;

  for (y=0;y<4;y++)
  {
    if (y<2) player=0;
    else player=1;

    for (x=0;x<4;x++)
    {
      pos=x+4*(y%2);

      point=calcCardPos(x,y);
      if (getDocument()->IsRunning())
      {
        height=getDocument()->GetHeight(player,pos);
        card=getDocument()->GetCard(player,pos,height);


        if (height==2)
          p->drawPixmap(point-TQPoint(CARD_X_DECK,CARD_Y_DECK),getDocument()->mPixDeck);

        if (cardmovecnt<1 || x!=cardmovex || y!=cardmovey)
        {
          if (height>0 ) p->drawPixmap(point,getDocument()->mPixCard[card]);
        }
        else
        {
           // moved to drawMove
           // if (height>0 ) p->drawPixmap(point,getDocument()->mPixDeck);
        }
      }
      else
      {
          p->drawPixmap(point,getDocument()->mPixDeck);
      }
    }
  }
}
// Draw the winner field
void LSkatView::drawFinal(TQPainter *p)
{
  int sc1,sc0,pt0,pt1;
  //TQPoint p1,p2;
  int trump;
  //TQRect r;
  TQString ld;
  int ts[10];

  TQFont font24 = KGlobalSettings::generalFont();
  font24.setPointSize(24);
  TQFont font14 = KGlobalSettings::generalFont();
  font14.setPointSize(13);

	//p1=status_rect3.topLeft();
	//p2=status_rect3.bottomRight();

  sc0=getDocument()->GetScore(0);
  sc1=getDocument()->GetScore(1);

  if (sc0>=120) pt0=4;
  else if (sc0>=90) pt0=3;
  else if (sc0>60) pt0=2;
  else if (sc0==60) pt0=1;
  else pt0=0;
  if (sc1>=120) pt1=4;
  else if (sc1>=90) pt1=3;
  else if (sc1>60) pt1=2;
  else if (sc1==60) pt1=1;
  else pt1=0;


  trump=getDocument()->GetTrump();



  TQString line1,line2,line3,line4,line5;
  TQString col1_3,col2_3,col3_3,col4_3;
  TQString col1_4,col2_4,col3_4,col4_4;
  TQRect sumrect;
  TQRect rect;
  TQRect brect1,brect2,brect3,brect4,brect5;
  TQRect brect1_3,brect2_3,brect3_3,brect4_3;
  TQRect brect1_4,brect2_4,brect3_4,brect4_4;

  // Calculate geometry
  line1=i18n("Game over");
  rect=p->window();
  //rect1.moveBy(0,FINAL_Y0-24);
  p->setFont(font24);
  brect1=p->boundingRect(rect,TQt::AlignHCenter|TQt::SingleLine|TQt::AlignTop,line1);
  //TQRect wrect=p->window();
  sumrect=brect1;

  if (sc0+sc1!=120)  // aborted
  {
    line2=i18n("Game was aborted - no winner");
    int hp=getDocument()->mPixTrump[trump].height()+5;
    rect=TQRect(0,hp>sumrect.height()?hp:sumrect.height(),p->window().width(),p->window().height());
    p->setFont(font14);
    brect2=p->boundingRect(rect,TQt::AlignHCenter|TQt::SingleLine|TQt::AlignTop,line2);
    sumrect|=brect2;
  }
  else
  {
    if (sc0==sc1)
    {
      line2=i18n("      Game is drawn");
    }
    else if (sc0>sc1)
    {
      line2=i18n("Player 1 - %1 won ").arg(getDocument()->GetName(0));
    }
    else
    {
      line2=i18n("Player 2 - %1 won ").arg(getDocument()->GetName(1));
    }
    int hp=getDocument()->mPixTrump[trump].height()+5;
    rect=TQRect(0,hp>sumrect.height()?hp:sumrect.height(),p->window().width(),p->window().height());
    p->setFont(font14);
    brect2=p->boundingRect(rect,TQt::AlignHCenter|TQt::SingleLine|TQt::AlignTop,line2);
    sumrect|=brect2;

    p->setFont(font14);
    col1_3=i18n("Score:");
    col1_4=TQString(" ");
    rect=TQRect(0,0,p->window().width(),p->window().height());
    brect1_3=p->boundingRect(rect,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,col1_3);
    ts[0]=brect1_3.width()+10;

    col2_3=getDocument()->GetName(0);
    rect=TQRect(0,0,p->window().width(),p->window().height());
    brect2_3=p->boundingRect(rect,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,col2_3);

    col2_4=getDocument()->GetName(1);
    rect=TQRect(0,0,p->window().width(),p->window().height());
    brect2_4=p->boundingRect(rect,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,col2_4);
    rect=brect2_3|brect2_4;
    ts[1]=ts[0]+rect.width()+10;


    col3_3.sprintf("%d",sc0);
    rect=TQRect(0,0,p->window().width(),p->window().height());
    brect3_3=p->boundingRect(rect,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,col3_3);

    col3_4.sprintf("%d",sc1);
    rect=TQRect(0,0,p->window().width(),p->window().height());
    brect3_4=p->boundingRect(rect,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,col3_4);
    rect=brect3_3|brect3_4;
    ts[2]=ts[1]+rect.width()+30;

    col4_3=i18n("%1 points").arg(pt0);
    rect=TQRect(0,0,p->window().width(),p->window().height());
    brect4_3=p->boundingRect(rect,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,col4_3);

    col4_4=i18n("%1 points").arg(pt1);
    rect=TQRect(0,0,p->window().width(),p->window().height());
    brect4_4=p->boundingRect(rect,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,col4_4);

    rect=brect4_3|brect4_4;
    ts[3]=ts[2]+rect.width()+10;
    ts[4]=0;

    line3=col1_3+TQString("\t")+col2_3+TQString("\t")+col3_3+TQString("\t")+col4_3;
    line4=col1_4+TQString("\t")+col2_4+TQString("\t")+col3_4+TQString("\t")+col4_4;
    brect3=TQRect(sumrect.left(),sumrect.bottom()+10,ts[3],brect4_3.height());
    brect4=TQRect(sumrect.left(),sumrect.bottom()+10+brect4_3.height()+6,ts[3],brect4_4.height());
    sumrect|=brect3;
    sumrect|=brect4;


    p->setFont(font14);
    if (sc0>=120)
    {
      line5=i18n("%1 won to nil. Congratulations!").arg(getDocument()->GetName(0));
      rect=TQRect(0,sumrect.height()+10,p->window().width(),p->window().height());
      brect5=p->boundingRect(rect,TQt::AlignHCenter|TQt::SingleLine|TQt::AlignTop,line5);
      sumrect|=brect5;
    }
    else if (sc0>=90)
    {
      if (sc0==90)
        line5=i18n("%1 won with 90 points. Super!").arg(getDocument()->GetName(0));
      else
        line5=i18n("%1 won over 90 points. Super!").arg(getDocument()->GetName(0));
      rect=TQRect(0,sumrect.height()+10,p->window().width(),p->window().height());
      brect5=p->boundingRect(rect,TQt::AlignHCenter|TQt::SingleLine|TQt::AlignTop,line5);
      sumrect|=brect5;
    }
    if (sc1>=120)
    {
      line5=i18n("%1 won to nil. Congratulations!").arg(getDocument()->GetName(1));
      rect=TQRect(0,sumrect.height()+10,p->window().width(),p->window().height());
      brect5=p->boundingRect(rect,TQt::AlignHCenter|TQt::SingleLine|TQt::AlignTop,line5);
      sumrect|=brect5;
    }
    else if (sc1>=90)
    {
      if (sc1==90)
        line5=i18n("%1 won with 90 points. Super!").arg(getDocument()->GetName(1));
      else
        line5=i18n("%1 won over 90 points. Super!").arg(getDocument()->GetName(1));
      rect=TQRect(0,sumrect.height()+10,p->window().width(),p->window().height());
      brect5=p->boundingRect(rect,TQt::AlignHCenter|TQt::SingleLine|TQt::AlignTop,line5);
      sumrect|=brect5;
    }
  }


  TQPoint offset=TQPoint(status_rect3.left()-sumrect.left(),status_rect3.top());
  sumrect.moveBy(offset.x(),offset.y());

  // draw actual strings and symbols
  TQRect borderrect=TQRect(sumrect.left()-20,sumrect.top()-20,sumrect.width()+40,sumrect.height()+40);
  p->drawRect(borderrect);
  drawBorder(p,borderrect,0,4,0);
  drawBorder(p,borderrect,10,1,1);


  p->setPen(black);
  p->setFont(font24);
  rect=sumrect;
  rect.setTop(brect1.top()+offset.y());
  //brect1.moveBy(offset.x(),offset.y());
  p->drawText(rect,TQt::AlignHCenter|TQt::SingleLine|TQt::AlignTop,line1);

  p->setFont(font14);
  p->setPen(COL_PLAYER);
  rect=sumrect;
  rect.setTop(brect2.top()+offset.y());
  //brect2.moveBy(offset.x(),offset.y());
  p->drawText(rect,TQt::AlignHCenter|TQt::SingleLine|TQt::AlignTop,line2);

  p->drawPixmap(sumrect.topLeft()+TQPoint(-5,-5), getDocument()->mPixTrump[trump]);
  p->drawPixmap(sumrect.topLeft()+TQPoint(5,-5)+TQPoint(sumrect.width()-getDocument()->mPixTrump[trump].width(),0),
                getDocument()->mPixTrump[trump]);


  if (!col1_3.isNull())
  {
    p->setTabArray(ts);
    p->setFont(font14);
    p->setPen(TQt::black);
    rect=sumrect;
    rect.setTop(brect3.top()+offset.y());

    // Workaround for the next line where the ExpandTab crashes!!!
    drawTabText(p,rect,line3,ts);
    // p->drawText(rect,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop|TQt::ExpandTabs,line3);
    rect=sumrect;
    rect.setTop(brect4.top()+offset.y());
    // Workaround for the next line where the ExpandTab crashes!!!
    drawTabText(p,rect,line4,ts);
    // p->drawText(rect,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop|TQt::ExpandTabs,line4);
  }
  if (!line5.isNull())
  {
    p->setFont(font14);
    p->setPen(TQt::black);
    rect=sumrect;
    rect.setTop(brect5.top()+offset.y());
    p->drawText(rect,TQt::AlignHCenter|TQt::SingleLine|TQt::AlignTop,line5);
  }
}

// This function is just a workaround for the QT function drawText
// with TQt::EXpandTAbs eanbled. For some strange reasons this crashes...
void LSkatView::drawTabText(TQPainter *p,TQRect rect,TQString s,int *ts)
{
  int lcnt=0;

  // p->setPen(TQt::black);
  // p->drawRect(rect);
  while(s.length()>0 && (lcnt==0 || ts[lcnt-1]) )
  {
    int lpos=s.find("\t");
    int rpos=s.length()-lpos-1;
    if (lpos<0)
    {
      lpos=s.length();
      rpos=0;
    }
    TQString tmp=s.left(lpos);
    s=s.right(rpos);
    TQRect rect2=rect;
    if (lcnt>0)
      rect2.setLeft(rect.left()+ts[lcnt-1]);
    p->drawText(rect2,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,tmp);
    lcnt++;
  }
}

// Draw the status field at the right side
void LSkatView::drawStatus(TQPainter *p)
{
  TQPoint p1,p2;
  int trump;
  TQRect drawrect;
  // For loop
  TQRect srect[2];
  srect[0]=status_rect1;
  srect[1]=status_rect2;

  TQFont font10 = KGlobalSettings::generalFont();
  font10.setPointSize(13);
  p->setFont(font10);

  trump=getDocument()->GetTrump();


  // draw text
  TQString ld;
  TQString line1,line2,line3,line4,line2a,line2b,line2c;
  TQRect sumrect,rect,rect2,brect1,brect2,brect3,brect4;
  TQPoint pa;

  for (int pl=0;pl<2;pl++)
  {
    drawrect=TQRect(srect[pl].left()+14,srect[pl].top()+14,srect[pl].width()-28,srect[pl].height()-28);
    p1=drawrect.topLeft();
    p2=drawrect.bottomRight();

    // Draw border and field
    p->setPen(COL_STATUSBORDER);
    p->setBrush(COL_STATUSFIELD);
    p->drawRect(srect[pl]);
    drawBorder(p,srect[pl],0,4,0);
    drawBorder(p,srect[pl],10,1,1);


    // Player pl -------------------
    // line1=TQString(i18n("Player 1"))+TQString(TQCString(" - "))+getDocument()->GetName(0);
    line1=getDocument()->GetName(pl);
    brect1=p->boundingRect(drawrect,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line1);
    sumrect=brect1;

    if (getDocument()->IsRunning())
    {
      // Geometry and strings
      line2=i18n("Score:");
      rect=TQRect(drawrect.left(),sumrect.bottom()+16,drawrect.width(),drawrect.height()-sumrect.height());
      brect2=p->boundingRect(rect,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line2);
      sumrect|=brect2;
      line3=i18n("Move:");
      rect=TQRect(drawrect.left(),sumrect.bottom()+10,drawrect.width(),drawrect.height()-sumrect.height());
      brect3=p->boundingRect(rect,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line3);
      sumrect|=brect3;

      rect=brect2|brect3;
      rect.setWidth(rect.width()+10);
      line2a.sprintf("%3d",getDocument()->GetScore(pl));
      line2b.sprintf("%3d",getDocument()->GetMoveNo());

      // paint
      if (getDocument()->GetStartPlayer()==pl) p->setPen(COL_PLAYER);
      else p->setPen(black);
      p->drawText(brect1,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line1);
      p->setPen(black);
      p->drawText(brect2,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line2);
      p->drawText(brect3,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line3);
      rect2=TQRect(brect2.left()+rect.width(),brect2.top(),drawrect.width()-brect2.width()-rect.width(),brect2.height());
      p->drawText(rect2,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line2a);
      rect2=TQRect(brect3.left()+rect.width(),brect3.top(),drawrect.width()-brect3.width()-rect.width(),brect3.height());
      p->drawText(rect2,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line2b);

      pa=TQPoint(drawrect.width()-getDocument()->mPixTrump[trump].width(),drawrect.height()-getDocument()->mPixTrump[trump].height());
      if (getDocument()->GetStartPlayer()==pl)
        p->drawPixmap(p1+pa+TQPoint(3,3),getDocument()->mPixTrump[trump]);

      pa=TQPoint(drawrect.width()-getDocument()->mPixType[getDocument()->GetPlayedBy(pl)-1].width(),0);
      p->drawPixmap(p1+pa+TQPoint(3,-3), getDocument()->mPixType[getDocument()->GetPlayedBy(pl)-1]);
    }
    else // draw all time score
    {
      // Geometry and strings
      line2=i18n("Points:");
      rect=TQRect(drawrect.left(),sumrect.bottom()+6,drawrect.width(),drawrect.height()-sumrect.height());
      brect2=p->boundingRect(rect,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line2);
      sumrect|=brect2;

      line3=i18n("Won:");
      rect=TQRect(drawrect.left(),sumrect.bottom()+6,drawrect.width(),drawrect.height()-sumrect.height());
      brect3=p->boundingRect(rect,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line3);
      sumrect|=brect3;

      line4=i18n("Games:");
      rect=TQRect(drawrect.left(),sumrect.bottom()+6,drawrect.width(),drawrect.height()-sumrect.height());
      brect4=p->boundingRect(rect,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line4);
      sumrect|=brect4;

      rect=brect2|brect3|brect4;
      rect.setWidth(rect.width()+10);
      line2a.sprintf("%d",getDocument()->GetStatPoints(pl));
      line2b.sprintf("%d",getDocument()->GetStatWon(pl));
      line2c.sprintf("%d",getDocument()->GetStatGames(pl));

      // paint
      p->setPen(COL_PLAYER);
      p->drawText(brect1,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line1);
      p->setPen(black);
      p->drawText(brect2,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line2);
      p->drawText(brect3,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line3);
      p->drawText(brect4,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line4);
      rect2=TQRect(brect2.left()+rect.width(),brect2.top(),drawrect.width()-brect2.width()-rect.width()+5,brect2.height());
      p->drawText(rect2,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line2a);
      rect2=TQRect(brect3.left()+rect.width(),brect3.top(),drawrect.width()-brect3.width()-rect.width()+5,brect3.height());
      p->drawText(rect2,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line2b);
      rect2=TQRect(brect4.left()+rect.width(),brect4.top(),drawrect.width()-brect4.width()-rect.width()+5,brect4.height());
      p->drawText(rect2,TQt::AlignLeft|TQt::SingleLine|TQt::AlignTop,line2c);

      pa=TQPoint(drawrect.width()-getDocument()->mPixType[getDocument()->GetPlayedBy(pl)-1].width(),0);
      p->drawPixmap(p1+pa+TQPoint(3,-3), getDocument()->mPixType[getDocument()->GetPlayedBy(pl)-1]);

    }

  }// end pl
}

// paint function
void LSkatView::Paint(TQPainter *p)
{
    // If game is running
    drawStatus(p);
    drawDeck(p);
    if (getDocument()->IsRunning())
    {
      drawMove(p);
    }
    else if (getDocument()->WasRunning() && !getDocument()->IsIntro())
    {
      drawFinal(p);
    }
}

// paint event
void LSkatView::paintEvent( TQPaintEvent * e)
{
  if (getDocument()->IsIntro())
  {
    TQPixmap pm(this->rect().size());
    TQPainter p;
    TQBrush brush;
    p.begin(TQT_TQPAINTDEVICE(&pm),this);
     brush.setPixmap( getDocument()->mPixBackground );
    p.fillRect(0,0,this->rect().width(),this->rect().height(),brush);
    drawIntro(&p);
    p.end();
    bitBlt(this,0,0,&pm);
  }
  else
  {
    TQPainter paint( this );
    paint.setClipRect(e->rect());
    Paint( &paint );
  }
}


// x=0..4, y=0..4
TQPoint LSkatView::calcCardPos(int x,int y)
{
  TQPoint point;
    point=TQPoint(CARD_X_OFFSET+x*(CARD_X_SPACE+getDocument()->cardsize.width()),
                 CARD_Y_OFFSET+y*(CARD_Y_SPACE+getDocument()->cardsize.height()));
    if (y>=2) point+=TQPoint(0,CARD_Y_BOARD_OFFSET);
    point+=TQPoint(CARD_X_DECK,CARD_Y_DECK);
  return point;
}

// mouse click event
void LSkatView::mousePressEvent( TQMouseEvent *mouse )
{
  if (mouse->button()!=Qt::LeftButton) return ;
  if (!getDocument()->IsRunning()) return ;

  if (getDocument()->GetMoveStatus()!=-1) return ;

  TQPoint point;
  int mx,my,player;

  point=mouse->pos();
  point-=TQPoint(CARD_X_OFFSET,CARD_Y_OFFSET);
  if (point.y()>2*(getDocument()->cardsize.height()+CARD_Y_SPACE))
  {
    point-=TQPoint(0,CARD_Y_BOARD_OFFSET+2*(getDocument()->cardsize.height()+CARD_Y_SPACE));
    player=1;
  }
  else
  {
     player=0;
  }
  if (point.x()<0 || point.y()<0) return ;
  mx=point.x()/(getDocument()->cardsize.width()+CARD_X_SPACE);
  my=point.y()/(getDocument()->cardsize.height()+CARD_Y_SPACE);
  if (mx>3 || my>1) return ;

  if (global_debug>10)
    printf("Type=%d Next=%d player=%d\n",
      getDocument()->QueryInputHandler()->QueryType(player),
      getDocument()->QueryInputHandler()->QueryNext(),player);
  if (getDocument()->QueryInputHandler()->IsInteractive(player) &&
      getDocument()->QueryInputHandler()->QueryNext()==player &&
      !getDocument()->IsLocked())
  {
    KEMessage *msg=new KEMessage;
    msg->AddData(TQCString("Move"),(short)player);
    msg->AddData(TQCString("MoveX"),(short)mx);
    msg->AddData(TQCString("MoveY"),(short)my);
    getDocument()->QueryInputHandler()->SetInput(msg);
    delete msg;
  }
  else
  {
    TQString m;
    switch(getDocument()->random(4))
    {
      case 0:
        m=i18n("Hold on... the other player hasn't been yet...");
      break;
      case 1:
        m=i18n("Hold your horses...");
      break;
      case 2:
        m=i18n("Ah ah ah... only one go at a time...");
      break;
      default:
        m=i18n("Please wait... it is not your turn.");
    }
     KMessageBox::information(this,m);
  }
}


void LSkatView::InitMove(int player,int mx,int my)
{
    cardmovex=mx;
    cardmovey=my+2*player;
    cardmoveunder=getDocument()->GetCard(player,mx+4*my,getDocument()->GetHeight(player,mx+4*my));
    introTimer->stop();
    moveTimer->start(MOVE_TIMER_DELAY,FALSE);
    cardmovecnt=0;
    cardorigin=calcCardPos(mx,my+2*player);
    if (getDocument()->GetCurrentPlayer()==0)
      cardend=TQPoint(CARD_X_MOVE1,CARD_Y_MOVE1);
    else cardend=TQPoint(CARD_X_MOVE2,CARD_Y_MOVE2);
    update(TQRect(
            cardorigin-TQPoint(CARD_X_DECK,CARD_Y_DECK),
            getDocument()->cardsize+TQSize(CARD_X_DECK,CARD_Y_DECK)));

    TQPoint point1=TQPoint(CARD_X_MOVE1,CARD_Y_MOVE1);
    TQPoint point2=TQPoint(CARD_X_MOVE2,CARD_Y_MOVE2);
    update(TQRect(point1,getDocument()->cardsize));
    update(TQRect(point2,getDocument()->cardsize));
}
void LSkatView::introTimerReady()
{
  if (!getDocument()->IsIntro())
  {
    introTimer->stop();
    return ;
  }
  introcnt++;
  if (introcnt>NO_OF_CARDS*4)
  {
    introcnt=0;
    for (int i=0;i<NO_OF_CARDS;i++)
    {
      introCards[i]=getDocument()->random(NO_OF_CARDS);
    }
  }
  else if (introcnt<NO_OF_CARDS)
  {
    repaint(false);
  }
}

void LSkatView::moveTimerReady()
{
  TQPoint pos;
  TQString ld,s;
  if (cardmovecnt>=MOVECOUNTER)
  {
    LSkatApp *m=(LSkatApp *) parentWidget();
    moveTimer->stop();
    cardmovecnt=0;
    update(TQRect(cardend,getDocument()->cardsize));
    update(TQRect(cardorigin,getDocument()->cardsize));
    update(status_rect1);
    update(status_rect2);
    m->MoveFinished();

  }
  else
  {
    pos=cardorigin+(cardend-cardorigin)*cardmovecnt/MOVECOUNTER;
    update(TQRect(pos,getDocument()->cardsize));
    cardmovecnt++;
    pos=cardorigin+(cardend-cardorigin)*cardmovecnt/MOVECOUNTER;
    update(TQRect(pos,getDocument()->cardsize));
    // Turning of the card
    if ( cardmoveunder>=0)
    {
      update(TQRect(cardorigin,getDocument()->cardsize));
    }
  }
}

void LSkatView::updateStatus()
{
  update(status_rect1);
  update(status_rect2);
}

#include "lskatview.moc"
