/* -------------------------------------------------------------
   KDE Tuberling
   Play ground widget
   mailto:e.bischoff@noos.fr
 ------------------------------------------------------------- */


#ifndef _PLAYGROUND_H_
#define _PLAYGROUND_H_

#include <kprinter.h>

#include <tqwidget.h>
#include <tqbitmap.h>
#include <tqptrlist.h>

#include "todraw.h"
#include "action.h"

class TQDomDocument;
class TopLevel;

class PlayGround : public TQWidget
{
  Q_OBJECT
  TQ_OBJECT

public:

  PlayGround(TopLevel *parent, const char *name, uint selectedGameboard);
  ~PlayGround();

  void reset();
  void change(uint selectedGameboard);
  void repaintAll();
  bool undo();
  bool redo();
  bool loadFrom(const TQString &name);
  bool saveAs(const TQString &name);
  bool printPicture(KPrinter &printer) const;
  TQPixmap getPicture() const;

  inline bool isFirstAction() const { return currentAction == 0; }
  inline bool isLastAction() const { return currentAction >= history.count(); }

protected:

  virtual void paintEvent(TQPaintEvent *event);
  virtual void mousePressEvent(TQMouseEvent *event);
  virtual void mouseReleaseEvent(TQMouseEvent *event);

private:

  bool registerPlayGrounds(TQDomDocument &layoutDocument);
  bool loadPlayGround(TQDomDocument &layoutDocument, uint toLoad);
  void loadFailure();
  void setupGeometry();
  bool zone(TQPoint &position);
  void drawText(TQPainter &artist, TQRect &area, TQString &textId) const;
  void drawGameboard(TQPainter &artist, const TQRect &area) const;

private:

  TQPixmap gameboard;		// Picture of the game board
  TQBitmap masks;		// Pictures of the objects' shapes
  TQRect editableArea;           // Part of the gameboard where the player can lay down objects
  TQString menuItem,		// Menu item describing describing this gameboard
          editableSound;        // Sound associated with this area
  int texts,                    // Number of categories of objects names
      decorations;              // Number of draggable objects on the right side of the gameboard
  TQRect *textsLayout,           // Positions of the categories names
        *objectsLayout;         // Position of the draggable objects on right side of the gameboard
  TQString *textsList,           // List of the message numbers associated with categories
          *soundsList;          // List of sounds associated with each object

  TQCursor *draggedCursor;       // Cursor's shape for currently dragged object
  ToDraw draggedObject;         // Object currently dragged
  int draggedZOrder;            // Z-order (in to-draw buffer) of this object

  TQPtrList<ToDraw> toDraw;      // List of objects in z-order
  TQPtrList<Action> history;     // List of actions in chronological order
  unsigned int currentAction;   // Number of current action (not the last one if used "undo" button!)

  TopLevel *topLevel;		// Top-level window
};

#endif
