#ifndef _MAP_WIDGET_H
#define _MAP_WIDGET_H


#include <tqwidget.h>
#include <tqframe.h>
#include <tqpixmap.h>

#include <tqgridview.h>

#include <tqtimer.h>

#include "gamecore.h"
#include "images.h"

class ConquestMap : public TQGridView
{
    Q_OBJECT
  TQ_OBJECT

    // Constructors
public:
    ConquestMap( Map *newMap, TQWidget *parent = 0 );
    virtual ~ConquestMap();

    // Interface
public:
    void unselectPlanet();

protected:
    virtual void contentsMousePressEvent( TQMouseEvent *e );
    virtual void contentsMouseMoveEvent( TQMouseEvent *e );
    virtual void paintCell( TQPainter *p, int row, int col );

private slots:
    void mapUpdate();
    void squareBlink();

signals:
    void planetSelected( Planet * );
    void planetHighlighted( Planet * );

private:
    const int SECTOR_HEIGHT;
    const int SECTOR_WIDTH;

    const int BOARD_HEIGHT;
    const int BOARD_WIDTH;

    void drawSector( TQPainter *, Sector &, bool borderStrobe = true, bool highlight = false );

    Map *map;
    TQColor gridColor;
    TQFont labelFont;

    int hiLiteRow, hiLiteCol;
};


#endif
