/***************************************************************************
                                   kclientdialog.h
                                  -----------------
    Developers: (c) 2000-2001 Nikolas Zimmermann <wildfox@kde.org>
                (c) 2000-2001 Daniel Molkentin <molkentin@kde.org>

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCLIENTDIALOG_H
#define KCLIENTDIALOG_H

#include <kapplication.h>
#include <kconfig.h>
#include <dnssd/servicebrowser.h>
#include <dnssd/remoteservice.h>
#include <tqstring.h>
#include <tqpushbutton.h>
#include <tqlineedit.h>
#include <tqspinbox.h>
#include <kdialogbase.h>
#include "dialogs/connectDlg.h"

class KClientDialog : public KDialogBase
{
	Q_OBJECT
  TQ_OBJECT
public:
	KClientDialog(TQWidget *parent = 0, const char *name = 0);
	~KClientDialog();

	TQString port() const;
	TQString host() const;
	TQString nickname() const;

public slots:
        virtual void slotOk();
        virtual void slotCancel();
	void slotReturnPressed(const TQString &hostname);
	void nextBatch();
	void gameSelected(int);	
        void slotCheckEnableOk();

signals:
	void sigConnectServer();
	void sigCancelConnect();

private:
	KConfig *m_config;
	DNSSD::ServiceBrowser *m_browser;
	clientConnectDlg *m_mainWidget;
};

#endif
