/***************************************************************************

                   initialisation part of kvoctrain

    -----------------------------------------------------------------------

    begin          : Thu Mar 11 20:50:53 MET 1999

    copyright      : (C) 1999-2001 Ewald Arnold <kvoctrain@ewald-arnold.de>
                     (C) 2001 The KDE-EDU team
                     (C) 2004-2005 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kvoctrain.h"

#include "common-dialogs/ProgressDlg.h"

#include <tqclipboard.h>
#include <tqtimer.h>

#include <klineedit.h>
#include <kcombobox.h>
#include <kstatusbar.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#include <klocale.h>

#include "prefs.h"

kvoctrainApp::kvoctrainApp(TQWidget *parent, const char *name)
: KMainWindow(parent, name)
{
  doc = 0;
  view = 0;
  header_m = 0;
  btimer = 0;
  querymode = false;
  shiftActive = false;
  altActive = false;
  controlActive = false;
  act_lesson = 0;
  searchpos = 0;
  vslide_label = 0;
  pron_label = 0;
  rem_label = 0;
  type_label = 0;
  pdlg = 0;
  pbar = 0;
  m_newStuff = 0;

  simpleQueryDlg = 0;
  mcQueryDlg = 0;
  verbQueryDlg = 0;
  randomQueryDlg = 0;
  adjQueryDlg = 0;
  artQueryDlg = 0;
  entryDlg = 0;

  initStatusBar();
  initActions();

  readOptions();

  initDoc();
  initView();

  int cc = Prefs::currentCol();
  int cr = Prefs::currentRow();
  if (cc <= KV_COL_LESS)
    cc = KV_COL_LESS+1;

  view->getTable()->updateContents(cr, cc);
  view->getTable()->clearSelection();
  view->getTable()->selectRow(cr);

  editRemoveSelectedArea->setEnabled(view->getTable()->numRows() > 0);

  querying = false;
  btimer = new TQTimer( this );
  connect( btimer, TQT_SIGNAL(timeout()), this, TQT_SLOT(slotTimeOutBackup()) );
  if (Prefs::autoBackup())
    btimer->start(Prefs::backupTime() * 60 * 1000, TRUE);
}


void kvoctrainApp::initActions()
{
  fileNew = KStdAction::openNew(TQT_TQOBJECT(this), TQT_SLOT(slotFileNew()), actionCollection());
  fileNew->setWhatsThis(i18n("Creates a new blank vocabulary document"));
  fileNew->setToolTip(fileNew->whatsThis());

  fileOpen = KStdAction::open(TQT_TQOBJECT(this), TQT_SLOT(slotFileOpen()), actionCollection());
  fileOpen->setWhatsThis(i18n("Opens an existing vocabulary document"));
  fileOpen->setToolTip(fileOpen->whatsThis());

  fileOpenExample = new KAction(i18n("Open &Example..."), "fileopen", 0, TQT_TQOBJECT(this), TQT_SLOT(slotFileOpenExample()), actionCollection(), "file_open_example");
  fileOpen->setWhatsThis(i18n("Open a vocabulary document"));
  fileOpen->setToolTip(fileOpen->whatsThis());

  fileGHNS = new KAction(i18n("&Get New Vocabularies..."), "knewstuff", CTRL+Key_G, TQT_TQOBJECT(this), TQT_SLOT(slotGHNS()), actionCollection(), "file_ghns");
  fileGHNS->setWhatsThis(i18n("Downloads new vocabularies"));
  fileGHNS->setToolTip(fileGHNS->whatsThis());

  fileOpenRecent = KStdAction::openRecent(TQT_TQOBJECT(this), TQT_SLOT(slotFileOpenRecent(const KURL&)), actionCollection());

  fileMerge = new KAction(i18n("&Merge..."), 0, 0, TQT_TQOBJECT(this), TQT_SLOT(slotFileMerge()), actionCollection(), "file_merge");
  fileMerge->setWhatsThis(i18n("Merge an existing vocabulary document with the current one"));
  fileMerge->setToolTip(fileOpen->whatsThis());

  fileSave = KStdAction::save(TQT_TQOBJECT(this), TQT_SLOT(slotFileSave()), actionCollection());
  fileSave->setWhatsThis(i18n("Save the active vocabulary document"));
  fileSave->setToolTip(fileSave->whatsThis());

  fileSaveAs = KStdAction::saveAs(TQT_TQOBJECT(this), TQT_SLOT(slotFileSaveAs()), actionCollection());
  fileSaveAs->setWhatsThis(i18n("Save the active vocabulary document with a different name"));
  fileSaveAs->setToolTip(fileSaveAs->whatsThis());

  filePrint = KStdAction::print(TQT_TQOBJECT(this), TQT_SLOT(slotFilePrint()), actionCollection());
  filePrint->setWhatsThis(i18n("Print the active vocabulary document"));
  filePrint->setToolTip(filePrint->whatsThis());

  fileQuit = KStdAction::quit(TQT_TQOBJECT(this), TQT_SLOT(slotFileQuit()), actionCollection());
  fileQuit->setWhatsThis(i18n("Quit KVocTrain"));
  fileQuit->setToolTip(fileQuit->whatsThis());

  editCopy = KStdAction::copy(TQT_TQOBJECT(this), TQT_SLOT(slotEditCopy()), actionCollection());
  editCopy->setWhatsThis(i18n("Copy"));
  editCopy->setToolTip(editCopy->whatsThis());

  editPaste = KStdAction::paste(TQT_TQOBJECT(this), TQT_SLOT(slotEditPaste()), actionCollection());
  editPaste->setWhatsThis(i18n("Paste"));
  editPaste->setToolTip(editPaste->whatsThis());

  editSelectAll = KStdAction::selectAll(TQT_TQOBJECT(this), TQT_SLOT(slotSelectAll()), actionCollection());
  editSelectAll->setWhatsThis(i18n("Select all rows"));
  editSelectAll->setToolTip(editSelectAll->whatsThis());

  editClearSelection = KStdAction::deselect(TQT_TQOBJECT(this), TQT_SLOT(slotCancelSelection()), actionCollection());
  editClearSelection->setWhatsThis(i18n("Deselect all rows"));
  editClearSelection->setToolTip(editClearSelection->whatsThis());

  editSearchFromClipboard =  KStdAction::find(TQT_TQOBJECT(this), TQT_SLOT(slotSmartSearchClip()), actionCollection());
  editSearchFromClipboard->setWhatsThis(i18n("Search for the clipboard contents in the vocabulary"));
  editSearchFromClipboard->setToolTip(editSearchFromClipboard->whatsThis());

  editAppend = new KAction(i18n("&Append New Entry"), "insert_table_row", "Insert", TQT_TQOBJECT(this), TQT_SLOT(slotAppendRow()), actionCollection(),"edit_append");
  editAppend->setWhatsThis(i18n("Append a new row to the vocabulary"));
  editAppend->setToolTip(editAppend->whatsThis());

  editEditSelectedArea = new KAction(i18n("&Edit Selected Area..."), "edit_table_row", "Ctrl+Return", TQT_TQOBJECT(this), TQT_SLOT(slotEditRow()), actionCollection(),"edit_edit_selected_area");
  editEditSelectedArea->setWhatsThis(i18n("Edit the entries in the selected rows"));
  editEditSelectedArea->setToolTip(editEditSelectedArea->whatsThis());

  editRemoveSelectedArea = new KAction(i18n("&Remove Selected Area"), "delete_table_row", "Delete", TQT_TQOBJECT(this), TQT_SLOT(slotRemoveRow()), actionCollection(),"edit_remove_selected_area");
  editRemoveSelectedArea->setWhatsThis(i18n("Delete the selected rows"));
  editRemoveSelectedArea->setToolTip(editRemoveSelectedArea->whatsThis());

  editSaveSelectedArea = new KAction(i18n("Save E&ntries in Query As..."), KGlobal::iconLoader()->loadIcon("filesaveas", KIcon::Small), 0, TQT_TQOBJECT(this), TQT_SLOT(slotSaveSelection()), actionCollection(),"edit_save_selected_area");
  editSaveSelectedArea->setWhatsThis(i18n("Save the entries in the query as a new vocabulary"));
  editSaveSelectedArea->setToolTip(editSaveSelectedArea->whatsThis());

  vocabShowStatistics = new KAction(i18n("Show &Statistics"), "statistics", 0, TQT_TQOBJECT(this), TQT_SLOT(slotShowStatist()), actionCollection(),"vocab_show_statistics");
  vocabShowStatistics->setWhatsThis(i18n("Show statistics for the current vocabulary"));
  vocabShowStatistics->setToolTip(vocabShowStatistics->whatsThis());

  vocabAssignLessons = new KAction(i18n("Assign L&essons..."), "rand_less", 0, TQT_TQOBJECT(this), TQT_SLOT(slotCreateRandom()), actionCollection(),"vocab_assign_lessons");
  vocabAssignLessons->setWhatsThis(i18n("Create random lessons with unassigned entries"));
  vocabAssignLessons->setToolTip(vocabAssignLessons->whatsThis());

  vocabCleanUp = new KAction(i18n("&Clean Up"), "cleanup", 0, TQT_TQOBJECT(this), TQT_SLOT(slotCleanVocabulary()), actionCollection(),"vocab_clean_up");
  vocabCleanUp->setWhatsThis(i18n("Remove entries with same content from vocabulary"));
  vocabCleanUp->setToolTip(vocabCleanUp->whatsThis());

  vocabAppendLanguage = new KSelectAction(i18n("&Append Language"), "insert_table_col", 0, actionCollection(), "vocab_append_language");
  connect(vocabAppendLanguage->popupMenu(), TQT_SIGNAL(aboutToShow()), TQT_TQOBJECT(this), TQT_SLOT(aboutToShowVocabAppendLanguage()));
  connect (vocabAppendLanguage->popupMenu(), TQT_SIGNAL(activated(int)), TQT_TQOBJECT(this), TQT_SLOT(slotAppendLang(int)));
  connect (vocabAppendLanguage->popupMenu(), TQT_SIGNAL(highlighted(int)), TQT_TQOBJECT(this), TQT_SLOT(slotHeaderStatus(int)));

  vocabSetLanguage = new KSelectAction(i18n("Set &Language"), "set_language", 0, actionCollection(), "vocab_set_language");
  connect(vocabSetLanguage->popupMenu(), TQT_SIGNAL(aboutToShow()), TQT_TQOBJECT(this), TQT_SLOT(aboutToShowVocabSetLanguage()));

  vocabRemoveLanguage = new KSelectAction(i18n("&Remove Language"), "delete_table_col", 0, actionCollection(), "vocab_remove_language");
  connect(vocabRemoveLanguage->popupMenu(), TQT_SIGNAL(aboutToShow()), TQT_TQOBJECT(this), TQT_SLOT(aboutToShowVocabRemoveLanguage()));
  connect(vocabRemoveLanguage->popupMenu(), TQT_SIGNAL(activated(int)), TQT_TQOBJECT(this), TQT_SLOT(slotHeaderCallBack(int)));
  connect(vocabRemoveLanguage->popupMenu(), TQT_SIGNAL(highlighted(int)), TQT_TQOBJECT(this), TQT_SLOT(slotHeaderStatus(int)));

  vocabDocumentProperties = new KAction(i18n("Document &Properties"), 0, 0, TQT_TQOBJECT(this), TQT_SLOT(slotDocProps()), actionCollection(), "vocab_document_properties");
  vocabDocumentProperties->setWhatsThis(i18n("Edit document properties"));
  vocabDocumentProperties->setToolTip(vocabAppendLanguage->whatsThis());

  vocabLanguageProperties = new KAction(i18n("Lan&guage Properties"), 0, 0, TQT_TQOBJECT(this), TQT_SLOT(slotDocPropsLang()), actionCollection(), "vocab_language_properties");
  vocabLanguageProperties->setWhatsThis(i18n("Edit language properties in current document"));
  vocabLanguageProperties->setToolTip(vocabSetLanguage->whatsThis());

  lessons = new KComboBox(this);
  lessons->setMinimumWidth(160);
  connect(lessons, TQT_SIGNAL(highlighted(int)), this, TQT_SLOT(slotChooseLesson(int)));
  lessons->setFocusPolicy(TQ_NoFocus);

  vocabLessons = new KWidgetAction(lessons, i18n("Lessons"), 0, TQT_TQOBJECT(this), 0, actionCollection(), "vocab_lessons");
  vocabLessons->setWhatsThis(i18n("Choose current lesson"));
  vocabLessons->setToolTip(vocabLessons->whatsThis());

  searchLine = new KLineEdit(this);
  searchLine->setFocusPolicy(TQ_ClickFocus);
  connect (searchLine, TQT_SIGNAL(returnPressed()), this, TQT_SLOT(slotSearchNext()));
  connect (searchLine, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(slotResumeSearch(const TQString&)));

  vocabSearch = new KWidgetAction(searchLine, i18n("Smart Search"), 0, TQT_TQOBJECT(this), 0, actionCollection(), "vocab_search");
  vocabSearch->setAutoSized(true);
  vocabSearch->setWhatsThis(i18n("Search vocabulary for specified text "));
  vocabSearch->setToolTip(vocabSearch->whatsThis());
  /*
  learningResumeQuery = new KAction(i18n("Resume &Query..."), "run_query", 0, this, TQT_SLOT(slotRestartQuery()), actionCollection(),"learning_resume_query");
  //learningResumeQuery->setWhatsThis(i18n(""));
  learningResumeQuery->setToolTip(learningResumeQuery->whatsThis());

  learningResumeMultipleChoice = new KAction(i18n("&Resume Multiple Choice..."), "run_multi", 0, this, TQT_SLOT(slotRestartQuery()), actionCollection(),"learning_resume_multiple_choice");
  //learningResumeMultipleChoice->setWhatsThis(i18n(""));
  learningResumeMultipleChoice->setToolTip(learningResumeMultipleChoice->whatsThis());
  */
  configApp = KStdAction::preferences(TQT_TQOBJECT(this), TQT_SLOT( slotGeneralOptions()), actionCollection());
  configApp->setWhatsThis(i18n("Show the configuration dialog"));
  configApp->setToolTip(configApp->whatsThis());

  /*configQueryOptions = new KAction(i18n("Configure &Query..."), "configure_query", 0, this, TQT_SLOT(slotQueryOptions()), actionCollection(),"config_query_options");
  configQueryOptions->setWhatsThis(i18n("Show the query configuration dialog"));
  configQueryOptions->setToolTip(configQueryOptions->whatsThis());*/

  actionCollection()->setHighlightingEnabled(true);
  connect(actionCollection(), TQT_SIGNAL(actionStatusText(const TQString &)), this, TQT_SLOT(slotStatusHelpMsg(const TQString &)));
  //connect(actionCollection(), TQT_SIGNAL(actionHighlighted(KAction *, bool)), this, TQT_SLOT(slotActionHighlighted(KAction *, bool)));

  if (!initialGeometrySet())
      resize( TQSize(550, 400).expandedTo(minimumSizeHint()));
  setupGUI(ToolBar | Keys | StatusBar | Create);
  setAutoSaveSettings();

  configToolbar = actionCollection()->action("options_configure_toolbars");
  configToolbar->setWhatsThis(i18n("Toggle display of the toolbars"));
  configToolbar->setToolTip(configToolbar->whatsThis());

  learn_menu = (TQPopupMenu*) child( "learning", "KPopupMenu" );
  connect(learn_menu, TQT_SIGNAL(activated(int)), this, TQT_SLOT(slotHeaderCallBack(int)));
  connect(learn_menu, TQT_SIGNAL(highlighted(int)), this, TQT_SLOT(slotHeaderStatus(int)));
  connect(learn_menu, TQT_SIGNAL(aboutToShow()), this, TQT_SLOT(aboutToShowLearn()));
}


void kvoctrainApp::initStatusBar()
{
  type_label = new TQLabel(statusBar());
  type_label->setFrameStyle(TQFrame::NoFrame);
  statusBar()->addWidget(type_label, 150);

  pron_label = new TQLabel(statusBar());
  pron_label->setFrameStyle(TQFrame::NoFrame);
  pron_label->setFont(Prefs::iPAFont());
  statusBar()->addWidget(pron_label, 200);

  rem_label = new TQLabel(statusBar());
  rem_label->setFrameStyle(TQFrame::NoFrame);
  statusBar()->addWidget(rem_label, 150);
}


void kvoctrainApp::initDoc( )
{
  if (fileOpenRecent->items().count() > 0)
    doc = new kvoctrainDoc(TQT_TQOBJECT(this), fileOpenRecent->items()[0]);
  else
    doc = new kvoctrainDoc(TQT_TQOBJECT(this), KURL(""));

  loadDocProps(doc);
  if (doc->numLangs() == 0)
    doc->appendLang("en");
  connect (doc, TQT_SIGNAL (docModified(bool)), this, TQT_SLOT(slotModifiedDoc(bool)));
  doc->setModified(false);
}


void kvoctrainApp::initView()
{
  view = new kvoctrainView(doc, langset, this);
  setCentralWidget(view);
  slotStatusMsg(IDS_DEFAULT);
}
