/***************************************************************************
                         kpercentage.cpp  -  description
                            -------------------
   begin                : Fre Nov 16 14:52:33 CET 2001
   copyright            : (C) 2001 by Matthias Messmer &
                                      Carsten Niehaus &
                                      Robert Gogolok
   email                : bmlmessmer@web.de &
                          cniehaus@gmx.de &
                          mail@robert-gogolok.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// C/C++ includes
#include <stdlib.h>

// TQt includes
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>

// KDE includes
#include <khelpmenu.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpushbutton.h>
#include <kstandarddirs.h>

//local includes
#include "kpercentage.h"
#include "ksplashscreen.h"

KPercentage::KPercentage( const char *name ) :
        KDialog ( 0, name )
{
    // show splash screen
    KSplashScreen * splash_screen = new KSplashScreen( this, "splashscreen" );
    splash_screen->show();
    splash_screen->raise();

    // Icon loader for the button's icons
    KIconLoader icon_loader;

    // let's set a suitable, not too small font size
    TQFont the_font( font() );
    the_font.setPointSize( 14 );
    //the_font.setBold(true);
    setFont( the_font );

    // prepare exercise window, that will use the fontsize above!
    percent_main = new KPercentMain( this, "KPercentage" );

    // fixed geometry bacause of background pixmap
    setFixedSize( TQSize( 548, 248 ) );

    /** load and set background pixmap */
    TQPixmap bgp( locate( "data", TQApplication::reverseLayout() ? "kpercentage/pics/kpercentage_bg_rtl.png" : "kpercentage/pics/kpercentage_bg.png" ) );
    setBackgroundPixmap( bgp );


    TQLabel *label_number = new TQLabel( i18n( "Number of tasks:" ), this );
    TQLabel *label_level = new TQLabel( i18n( "Level:" ), this );
    TQLabel *label_choose = new TQLabel( i18n( "Choose an exercise type:" ), this );

    /** make labels transparent */
    label_number->setBackgroundPixmap( bgp );
    label_number->setBackgroundOrigin( TQLabel::ParentOrigin );
    label_level->setBackgroundPixmap( bgp );
    label_level->setBackgroundOrigin( TQLabel::ParentOrigin );
    label_choose->setBackgroundPixmap( bgp );
    label_choose->setBackgroundOrigin( TQLabel::ParentOrigin );

    KPushButton *button_basevalue = new KPushButton( i18n( "x% &of ?? = y" ), this );
    KPushButton *button_percentvalue = new KPushButton( i18n( "x% of &y = ??" ), this );
    KPushButton *button_percentage = new KPushButton( i18n( "??% o&f x = y" ), this );
    KPushButton *button_random = new KPushButton( i18n( "??" ), this );
    KPushButton *button_help = new KPushButton( KStdGuiItem::help().text(), this );
    button_help->setIconSet( TQIconSet( icon_loader.loadIcon( "help", KIcon::NoGroup, 32 ) ) );
	KHelpMenu *help_menu = new KHelpMenu( this, KGlobal::instance()->aboutData(), true );
	button_help->setPopup( ( TQPopupMenu* ) ( help_menu->menu() ) );
    KPushButton *button_close = new KPushButton( i18n( "E&xit" ), this );
    button_close->setIconSet( TQIconSet( icon_loader.loadIcon( "exit", KIcon::NoGroup, 32 ) ) );

    combo_box_level = new KComboBox( this );
    combo_box_level->insertItem( i18n( "Easy" ) );
    combo_box_level->insertItem( i18n( "Medium" ) );
    combo_box_level->insertItem( i18n( "Crazy" ) );

    spin_box_number = new TQSpinBox( 1, 10, 1, this );
    spin_box_number->setValue( 5 );

    // connecting all the slots
    connect( button_basevalue, TQT_SIGNAL( clicked() ), this, TQT_SLOT( selBasevalue() ) );
    connect( button_percentvalue, TQT_SIGNAL( clicked() ), this, TQT_SLOT( selPercentvalue() ) );
    connect( button_percentage, TQT_SIGNAL( clicked() ), this, TQT_SLOT( selPercentage() ) );
    connect( button_random, TQT_SIGNAL( clicked() ), this, TQT_SLOT( selRandom() ) );
    connect( button_help, TQT_SIGNAL( clicked() ), this, TQT_SLOT( needHelp() ) );
    connect( button_close, TQT_SIGNAL( clicked() ), this, TQT_SLOT( accept() ) );

    ////////
    // begin layouting
    ////////
    TQVBoxLayout *main_layout = new TQVBoxLayout( this, 20, 20, "main_layout" );
    main_layout->setResizeMode( TQLayout::FreeResize );

    TQHBoxLayout *top_layout = new TQHBoxLayout( main_layout, -1, "top_layout" );
    top_layout->addWidget( label_number );
    top_layout->addWidget( spin_box_number );
    top_layout->addSpacing( 20 );
    top_layout->addStretch();
    top_layout->addWidget( label_level );
    top_layout->addWidget( combo_box_level );

    main_layout->addSpacing( 40 );
    main_layout->addStretch();

    TQHBoxLayout *bottom_layout = new TQHBoxLayout( main_layout, -1, "bottom_layout" );
    TQVBoxLayout *bLeftLayout = new TQVBoxLayout( bottom_layout );
    bLeftLayout->addWidget( label_choose );
    bLeftLayout->addSpacing( 10 );

    TQGridLayout *grid_layout = new TQGridLayout( bLeftLayout, 2, 2, 10 );
    grid_layout->addWidget( button_basevalue, 0, 0 );
    grid_layout->addWidget( button_percentvalue, 1, 0 );
    grid_layout->addWidget( button_percentage, 0, 1 );
    grid_layout->addWidget( button_random, 1, 1 );

    bottom_layout->addStretch();

    TQVBoxLayout *b_right_layout = new TQVBoxLayout( bottom_layout );
    b_right_layout->addStretch();
    b_right_layout->addWidget( button_help );
    b_right_layout->addSpacing( 10 );
    b_right_layout->addWidget( button_close );

    main_layout->addStretch();
    ////////
    // end layouting
    ////////

	////////
	// Tooltips
	TQToolTip::add( button_basevalue, i18n( "Exercises with base value omitted" ) );
	TQToolTip::add( button_percentvalue, i18n( "Exercises with percent value omitted" ) );
	TQToolTip::add( button_percentage, i18n( "Exercises with percentage omitted" ) );
	TQToolTip::add( button_random, i18n( "Several exercise types in random" ) );
	TQToolTip::add( spin_box_number, i18n( "Choose the number of exercises from 1 to 10." ) );
	TQToolTip::add( combo_box_level, i18n( "Choose the level of difficulty." ) );
	TQToolTip::add( button_close, i18n( "Close KPercentage." ) );
	TQToolTip::add( button_help, i18n( "Get some help." ) );

	////////
	// WhatsThis
	TQWhatsThis::add( button_basevalue, i18n( "Click here to start a sequence of exercises where the base value is omitted.") );
	TQWhatsThis::add( button_percentvalue, i18n( "Click here to start a sequence of exercises where the percent value is omitted." ) );
	TQWhatsThis::add( button_percentage, i18n( "Click here to start a sequence of exercises where the percentage is omitted." ) );
	TQWhatsThis::add( button_random, i18n( "Click here to start a sequence of exercises where one value is omitted at random." ) );
	TQWhatsThis::add( spin_box_number, i18n( "Here you can adjust the number of exercises from 1 to 10." ) );
	TQWhatsThis::add( combo_box_level, i18n( "Choose one of the levels <i>easy</i>, <i>medium</i>, and <i>crazy</i>." ) );
	TQWhatsThis::add( button_close, i18n( "Close KPercentage." ) );
	TQWhatsThis::add( button_help, i18n( "Get some help." ) );
}

void KPercentage::selPercentage()
{
    // set the proper value for KPercentMain::selected_type
    percent_main->selected_type = SEL_PERCENTAGE;
    // and lets go!
    startExercise();
}

void KPercentage::selBasevalue()
{
    // set the proper value for KPercentMain::selected_type
    percent_main->selected_type = SEL_BASEVALUE;
    // and lets go!
    startExercise();
}

void KPercentage::selPercentvalue()
{
    // set the proper value for KPercentMain::selected_type
    percent_main->selected_type = SEL_PERCENTVALUE;
    // and lets go!
    startExercise();
}

void KPercentage::selRandom()
{
    // set the proper value for KPercentMain::selected_type
    percent_main->selected_type = SEL_RANDOM;
    // and lets go!
    startExercise();
}

/** No descriptions */
void KPercentage::startExercise()
{
    // copy the actual settings to the KPercentMain instance
    percent_main->setNumber( spin_box_number->value() );
    percent_main->selected_level = combo_box_level->currentItem();
    percent_main->initExercise();
    TQPoint p = pos();
    hide();
    percent_main->move( p );
    percent_main->exec();
    move( p );
    show();
}

void KPercentage::needHelp()
{
    kapp->invokeHelp( "", "kpercentage" );
}

void KPercentage::closeEvent( TQCloseEvent * )
{
    exit( 0 );
}

#include "kpercentage.moc"
