/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;
import java.text.*;

class TabDialog  extends QTabDialog
{

protected String filename;
protected QFileInfo fileinfo;


TabDialog( QWidget parent, String name, String _filename )
{
    super( parent, name );
	filename = _filename;
	fileinfo = new QFileInfo(filename);
    setupTab1();
    setupTab2();
    setupTab3();

    connect( this, SIGNAL(" applyButtonPressed()"), qApp(), SLOT(" quit()") );
}

void setupTab1()
{
    QVBox tab1 = new QVBox( this );
    tab1.setMargin( 5 );

    new QLabel( "Filename:", tab1 );
    QLineEdit fname = new QLineEdit( filename, tab1 );
    fname.setFocus();

    new QLabel( "Path:", tab1 );
    QLabel path = new QLabel( fileinfo.dirPath( true ), tab1 );
    path.setFrameStyle( QFrame.Panel | QFrame.Sunken );

    new QLabel( "Size:", tab1 );
    QLabel size = new QLabel( fileinfo.size() + " KB", tab1 );
    size.setFrameStyle( QFrame.Panel | QFrame.Sunken );

	SimpleDateFormat dateFormat = new SimpleDateFormat("EE MMM d hh:mm:ss yyyy");

    new QLabel( "Last Read:", tab1 );
    QLabel lread = new QLabel( dateFormat.format(fileinfo.lastRead().getTime()), tab1 );
    lread.setFrameStyle( QFrame.Panel | QFrame.Sunken );

    new QLabel( "Last Modified:", tab1 );
    QLabel lmodif = new QLabel( dateFormat.format(fileinfo.lastModified().getTime()), tab1 );
    lmodif.setFrameStyle( QFrame.Panel | QFrame.Sunken );

    addTab( tab1, "General" );
}

void setupTab2()
{
    QVBox tab2 = new QVBox( this );
    tab2.setMargin( 5 );

    QButtonGroup bg = new QButtonGroup( 1, QGroupBox.Horizontal, "Permissions", tab2 );

    QCheckBox readable = new QCheckBox( "Readable", bg );
    if ( fileinfo.isReadable() )
        readable.setChecked( true );

    QCheckBox writable = new QCheckBox( "Writeable", bg );
    if ( fileinfo.isWritable() )
        writable.setChecked( true );

    QCheckBox executable = new QCheckBox( "Executable", bg );
    if ( fileinfo.isExecutable() )
        executable.setChecked( true );

    QButtonGroup bg2 = new QButtonGroup( 2, QGroupBox.Horizontal, "Owner", tab2 );

    new QLabel( "Owner", bg2 );
    QLabel owner = new QLabel( fileinfo.owner(), bg2 );
    owner.setFrameStyle( QFrame.Panel | QFrame.Sunken );

    new QLabel( "Group", bg2 );
    QLabel group = new QLabel( fileinfo.group(), bg2 );
    group.setFrameStyle( QFrame.Panel | QFrame.Sunken );

    addTab( tab2, "Permissions" );
}

void setupTab3()
{
    QVBox tab3 = new QVBox( this );
    tab3.setMargin( 5 );
    tab3.setSpacing( 5 );
    
    new QLabel( "Open " + filename + " with:", tab3 );

    QListBox prgs = new QListBox( tab3 );
    for ( int i = 0; i < 30; i++ ) {
        String prg = "Application " + i;
        prgs.insertItem( prg );
    }
    prgs.setCurrentItem( 3 );

    new QCheckBox( "Open files with the extension '" + fileinfo.extension() + "' always with this application", tab3 );

    addTab( tab3, "Applications" );
}
}
