/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;


class ImageTextEditor  extends QDialog
{
private QImage image;
private QComboBox languages;
private QComboBox keys;
private QMultiLineEdit text;
private QLineEdit newlang;
private QLineEdit newkey;



ImageTextEditor( QImage i, QWidget parent )
{
	this(i, parent, null, 0);
}

ImageTextEditor( QImage i, QWidget parent, String name, int f )
{
    super(parent,name,true,f);
    image = i;
    QVBoxLayout vbox = new QVBoxLayout(this,8);
    vbox.setAutoAdd(true);

    QGrid controls = new QGrid(3,QGrid.Horizontal,this);
    controls.setSpacing(8);
    QLabel l;
    l=new QLabel("Language",controls); l.setAlignment(AlignCenter);
    l=new QLabel("Key",controls); l.setAlignment(AlignCenter);
    new QLabel("",controls); // dummy
    languages = new QComboBox(controls);
    keys = new QComboBox(controls);
    QPushButton remove = new QPushButton("Remove",controls);

    newlang = new QLineEdit(controls);
    newkey = new QLineEdit(controls);
    QPushButton add = new QPushButton("Add",controls);

    text = new QMultiLineEdit(this);

    QHBox hbox = new QHBox(this);
    QPushButton cancel = new QPushButton("Cancel",hbox);
    QPushButton ok = new QPushButton("OK",hbox);

    connect(add,SIGNAL("clicked()"),
	this,SLOT("addText()"));

    connect(remove,SIGNAL("clicked()"),
	this,SLOT("removeText()"));

    connect(ok,SIGNAL("clicked()"),
	this,SLOT("accept()"));

    connect(cancel,SIGNAL("clicked()"),
	this,SLOT("reject()"));

    connect(languages,SIGNAL("activated(int)"),
	this,SLOT("updateText()"));

    connect(keys,SIGNAL("activated(int)"),
	this,SLOT("updateText()"));

    imageChanged();
}

void imageChanged()
{
    languages.clear();
    keys.clear();
    text.clear();
    languages.insertItem("<any>");

    languages.insertStringList( (String[]) image.textLanguages().toArray(new String[0]) );
    keys.insertStringList( (String[]) image.textKeys().toArray(new String[0]) );

    updateText();
}

public void accept()
{
    storeText();
    super.accept();
}

void updateText()
{
    storeText();
    newlang.setText(languages.currentText());
    newkey.setText(keys.currentText());
    String t = image.text(currKey(),currLang());

    text.setText(t);
}

String currKey()
{
    return newkey.text();
}

String currLang()
{
    String l = newlang.text();
    if ( l.equals("<any>") )
	l = "";
    return l;
}

String currText()
{
    String t = text.text();
    if ( t == null ) t = "";
    return t;
}


void removeText()
{
    image.setText(currKey(),currLang(),"");
}

void addText()
{
    storeText();
}

void storeText()
{
    if ( currKey().length() > 0 ) {
	image.setText(currKey(),currLang(),currText());
    }
}
}
