/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;
import java.math.*;



class FontDisplayer  extends QMainWindow {



class FontRowTable  extends QFrame {
private    QFont tablefont;
private    int row;

FontRowTable( QWidget parent )
{
	this(parent, null);
}

FontRowTable( QWidget parent, String name )
{
    super(parent,name);
    setBackgroundMode(PaletteBase);
    setFrameStyle(Panel|Sunken);
    setMargin(8);
    setRow(0);
    tablefont = QApplication.font();
}

public QSize sizeHint()
{
	return new QSize( 16*cellSize().width()+2*(margin()+frameWidth()),
	                  16*cellSize().height()+2*(margin()+frameWidth()) );
}

QSize cellSize()
{
    QFontMetrics fm = fontMetrics();
    return new QSize( fm.maxWidth(), fm.lineSpacing()+1 );
}

protected void paintEvent( QPaintEvent e )
{
    super.paintEvent(e);
System.out.println("In paintEvent");
    QPainter p = new QPainter(this);
    p.setClipRegion(e.region());
    QRect r = e.rect();
    QFontMetrics fm = fontMetrics();
    int ml = frameWidth()+margin() + 1 + (-fm.minLeftBearing() > 0 ? -fm.minLeftBearing() : 0);
    int mt = frameWidth()+margin();
    QSize cell = new QSize((width()-15-ml)/16,(height()-15-mt)/16);

    if ( cell.width() == 0 || cell.height() == 0 )
	return;

    int mini = r.left() / cell.width();
    int maxi = (r.right()+cell.width()-1) / cell.width();
    int minj = r.top() / cell.height();
    int maxj = (r.bottom()+cell.height()-1) / cell.height();

    int h = fm.height();

    QColor body = new QColor(255,255,192);
    QColor negative = new QColor(255,192,192);
    QColor positive = new QColor(192,192,255);
    QColor rnegative = new QColor(255,128,128);
    QColor rpositive = new QColor(128,128,255);

    for (int j = minj; j<=maxj; j++) {
	for (int i = mini; i<=maxi; i++) {
	    if ( i < 16 && j < 16 ) {
		int x = i * cell.width();
		int y = j* cell.height();

		char ch = (char) ((j*16+i) + (row*256));
		
		if ( fm.inFont(ch) ) {
		    int w = fm.width(ch);
		    int lb = fm.leftBearing(ch);
		    int rb = fm.rightBearing(ch);

		    x += ml;
		    y += mt+h;

		    p.fillRect(x,y,w,-h,new QBrush(body));
		    if ( w != 0) {
			if ( lb != 0 ) {
			    p.fillRect(x+(lb>0?0:lb), y-h/2, Math.abs(lb),-h/2,
				       new QBrush(lb < 0 ? negative : positive));
			}
			if ( rb != 0) {
			    p.fillRect(x+w-(rb>0?rb:0),y+2, Math.abs(rb),-h/2,
				       new QBrush(rb < 0 ? rnegative : rpositive));
			}
		    }
		    String s = "";
		    s += ch;
		    p.setPen(new QPen(Qt.black()));
		    p.drawText(x,y,s);
		}
	    }
	}
    }
	p.end();
}

void setRow(int r)
{
    row = r;

    QFontMetrics fm = fontMetrics();
    String str = "mLB=" + fm.minLeftBearing() + 
	             " mRB=" + fm.minRightBearing() + 
				 " mW=" + fm.maxWidth();

    emit("fontInformation", str);
    update();
}

void chooseFont()
{
    boolean[] ok = { true };
    QFont oldfont = tablefont;
    tablefont = QFontDialog.getFont(ok, oldfont, this);

    if (ok[0])
	setFont(tablefont);
    else
	tablefont = oldfont;


}
}

FontDisplayer( )
{
	this(null, null);
}

FontDisplayer( QWidget parent, String name )
{
    super(parent,name);
    FontRowTable table = new FontRowTable(this);
    QToolBar controls = new QToolBar(this);
    new QLabel(tr("Row:"), controls);
    QSpinBox row = new QSpinBox(0,255,1,controls);
    controls.addSeparator();
    QPushButton fontbutton = new QPushButton(tr("Font..."), controls);

    connect(row,SIGNAL("valueChanged(int)"),table,SLOT("setRow(int)"));
    connect(fontbutton, SIGNAL("clicked()"), table, SLOT("chooseFont()"));
    connect(table,SIGNAL("fontInformation(String)"),
	    statusBar(),SLOT("message(String)"));
    table.setRow(0);
    setCentralWidget(table);
}
}
