
  

#ifndef KJSEMBED_QCanvasItem_H
#define KJSEMBED_QCanvasItem_H

#include <kjs/interpreter.h>
#include <kjs/object.h>

#include <kjsembed/jsobjectproxy_imp.h>

class TQCanvasItem;

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

/**
 * Wrapper class for TQCanvasItem methods.
 *
 * @author Richard Moore, rich@kde.org
 */
class QCanvasItemImp : public JSProxyImp
{
public:
   /** Enumerates the constructors supported by this class. */
   enum Constructors {
       Constructor_QCanvasItem_1,

       LastConstuctor = -1
   };

   /** Enumerates the methods supported by this class. */
   enum Methods {

       Method_x_3,
       Method_y_4,
       Method_z_5,
       Method_moveBy_6,
       Method_move_7,
       Method_setX_8,
       Method_setY_9,
       Method_setZ_10,
       Method_animated_11,
       Method_setAnimated_12,
       Method_setVelocity_13,
       Method_setXVelocity_14,
       Method_setYVelocity_15,
       Method_xVelocity_16,
       Method_yVelocity_17,
       Method_advance_18,
       Method_collidesWith_19,
       Method_collisions_20,
       Method_setCanvas_21,
       Method_draw_22,
       Method_show_23,
       Method_hide_24,
       Method_setVisible_25,
       Method_isVisible_26,
       Method_setSelected_27,
       Method_isSelected_28,
       Method_setEnabled_29,
       Method_isEnabled_30,
       Method_setActive_31,
       Method_isActive_32,
       Method_visible_33,
       Method_selected_34,
       Method_enabled_35,
       Method_active_36,
       Method_rtti_37,
       Method_boundingRect_38,
       Method_boundingRectAdvanced_39,
       Method_canvas_40,
       Method_Last = -1
   };

   QCanvasItemImp( KJS::ExecState *exec, int id, bool constructor=false );
   ~QCanvasItemImp();

   /**
    * Adds the static bindings for this class to the specified Object. The
    * static bindings are the static methods and the enums of this class.
    */
   static void addStaticBindings( KJS::ExecState *exec, KJS::Object &object );

   /**
    * Adds the bindings for this class to the specified Object. The bindings
    * added are the instance methods of this class.
    */
   static void addBindings( KJS::ExecState *exec, KJS::Object &object );

   static TQCanvasItem *toQCanvasItem( KJS::Object &object );

   //
   // Constructors implemented by this class.
   //

   KJS::Object QCanvasItem_1( KJS::ExecState *exec, const KJS::List &args );

   //
   // Methods implemented by this class.
   //

   KJS::Value x_3( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value y_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value z_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value moveBy_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value move_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setX_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setY_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setZ_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value animated_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setAnimated_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setVelocity_13( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setXVelocity_14( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setYVelocity_15( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value xVelocity_16( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value yVelocity_17( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value advance_18( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value collidesWith_19( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value collisions_20( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setCanvas_21( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value draw_22( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value show_23( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value hide_24( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setVisible_25( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value isVisible_26( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setSelected_27( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value isSelected_28( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setEnabled_29( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value isEnabled_30( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setActive_31( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value isActive_32( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value visible_33( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value selected_34( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value enabled_35( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value active_36( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value rtti_37( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value boundingRect_38( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value boundingRectAdvanced_39( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value canvas_40( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );

   //
   // JS binding code.
   //

   /** Returns true iff this object implements the construct function. */
   virtual bool implementsConstruct() const { return cons; }

   /** Invokes the construct function. */
   virtual KJS::Object construct( KJS::ExecState *exec, const KJS::List &args );

   /** Returns true iff this object implements the call function. */
   virtual bool implementsCall() const { return !cons; }

   /** Invokes the call function. */
   virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );

private:
   TQCanvasItem *instance; // Temp
   int id;
   bool cons;
};

} // namespace KJSEmbed

#endif // KJSEMBED_QCanvasItem_H

// Local Variables:
// c-basic-offset: 4
// End:


