/*
 *  Copyright (C) 2001-2003, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include "global.h"
#include "jseventmapper.h"
#include <tqevent.h>
namespace KJSEmbed {

/** Used internally for the event handler table. */
struct EventType
{
    EventType( KJS::Identifier _id, TQEvent::Type _type ) :
	id(_id), type(_type) {;}

    const KJS::Identifier id;
    const TQEvent::Type type;
};

static EventType events[] = {
	EventType(KJS::Identifier("timerEvent"), TQEvent::Timer),

#ifdef ENABLE_CHILDEVENTS
    EventType( KJS::Identifier("childInsertEvent"), TQEvent::ChildInserted ),
    EventType( KJS::Identifier("childRemoveEvent"), TQEvent::ChildRemoved ),
#endif

    EventType( KJS::Identifier("mouseReleaseEvent"), TQEvent::MouseButtonRelease ),
    EventType( KJS::Identifier("mouseMoveEvent"), TQEvent::MouseMove ),
    EventType( KJS::Identifier("mouseDoubleClickEvent"), TQEvent::MouseButtonDblClick ),
    EventType( KJS::Identifier("mousePressEvent"), TQEvent::MouseButtonPress ),

    EventType( KJS::Identifier("keyPressEvent"), TQEvent::KeyPress ),
    EventType( KJS::Identifier("keyReleaseEvent"), TQEvent::KeyRelease ),

    EventType( KJS::Identifier("paintEvent"), TQEvent::Paint ),

    EventType( KJS::Identifier("moveEvent"), TQEvent::Move ),
    EventType( KJS::Identifier("resizeEvent"), TQEvent::Resize ),

    EventType( KJS::Identifier("closeEvent"), TQEvent::Close ),

    EventType( KJS::Identifier("showEvent"), TQEvent::Show ),
    EventType( KJS::Identifier("hideEvent"), TQEvent::Hide ),

    EventType( KJS::Identifier("dragEnterEvent"), TQEvent::DragEnter ),
    EventType( KJS::Identifier("dragMoveEvent"), TQEvent::DragMove ),
    EventType( KJS::Identifier("dragLeaveEvent"), TQEvent::DragLeave ),
    EventType( KJS::Identifier("dragResponseEvent"), TQEvent::DragResponse ),
    EventType( KJS::Identifier("dropEvent"), TQEvent::Drop ),

    EventType( KJS::Identifier(), TQEvent::None )
};

JSEventMapper::JSEventMapper()
{
    int i = 0;
    do {
	addEvent( events[i].id, events[i].type );
	i++;
    } while( events[i].type != TQEvent::None );
}

JSEventMapper::~JSEventMapper()
{
}

void JSEventMapper::addEvent( const KJS::Identifier &name, TQEvent::Type t )
{
    handlerToEvent.insert( name.qstring(), (const uint *) t );
    eventToHandler.insert( (long) t, &name );
}

TQEvent::Type JSEventMapper::findEventType( const KJS::Identifier &name ) const
{
    uint evt = (uint)(long)handlerToEvent[ name.qstring() ];
    return static_cast<TQEvent::Type>( evt );
}

} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:
