use ExtUtils::MakeMaker;
use Config;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

print "Trying to find some configuration information...\n";
my $kde_dirs = $ENV{KDEDIRS} || '/opt/trinity';
my $qt_dir = $ENV{QTDIR} || '/usr/lib/qt';
my $kde_inc = "$kde_dirs/include";
my $kde_lib = "$kde_dirs/lib";
my $qt_inc = "$qt_dir/include";
my $qt_lib = "$qt_dir/lib";
$kde_inc = undef unless -f "$kde_inc/dcopclient.h"; 
$kde_lib = undef unless -f "$kde_lib/libDCOP.$Config{dlext}";
$qt_dir = undef unless -f "$qt_inc/qglobal.h";

print "Path to Qt headers? [$qt_inc]: ";
chomp $input, $qt_inc = $input if (($input = <>) =~ /\S/);
print "Path to Qt libraries? [$qt_lib]: ";
chomp $input, $qt_lib = $input if (($input = <>) =~ /\S/);
print "Path to KDE headers? [$kde_inc]: ";
chomp $input, $kde_inc = $input if (($input = <>) =~ /\S/);
print "Path to KDE libraries? [$kde_lib]: ";
chomp $input, $kde_lib = $input if (($input = <>) =~ /\S/);

WriteMakefile(
    NAME	=> 'DCOP',
    VERSION_FROM => 'DCOP.pm',
    INC		=> "-I$qt_inc -I$kde_inc -I/usr/include/tqt",
    LIBS	=> "-L$qt_lib -lqt-mt -L$kde_lib -lkdecore -lDCOP",
    XS		=> {'DCOP.xs' => 'DCOP.cpp'},
    XSOPT	=> '-C++',
    CCFLAGS	=> '-x c++',
);

sub MY::xs_c {
    package MY;
    my $hack = shift->SUPER::xs_c(@_);
    $hack =~ s/\.c/.cpp/g;
    $hack;
}

