/* 	
 *	This file contains the B2 configuration widget
 *
 *	Copyright (c) 2001
 *		Karol Szwed <gallium@kde.org>
 *		http://gallium.n3.net/
 */

#ifndef _KDE_B2CONFIG_H
#define _KDE_B2CONFIG_H

#include <tqcheckbox.h>
#include <tqgroupbox.h>
#include <tqhgroupbox.h>
#include <tqlabel.h>
#include <tqcombobox.h>
#include <kconfig.h>

class B2Config: public TQObject
{
	Q_OBJECT

	public:
		B2Config( KConfig* conf, TQWidget* parent );
		~B2Config();

	// These public signals/slots work similar to KCM modules
	signals:
		void changed();

	public slots:
		void load( KConfig* conf );	
		void save( KConfig* conf );
		void defaults();

	protected slots:
		void slotSelectionChanged();	// Internal use

	private:
		KConfig*   b2Config;
		TQCheckBox* cbColorBorder;
		TQCheckBox*  showGrabHandleCb;
		TQHGroupBox* actionsGB;
		TQComboBox*  menuDblClickOp;
		TQWidget* gb;
};

#endif

// vim: ts=4
