/***************************************************************************
 *   KT icons implementation.                                              *
 *   --------------------------------------------------------------------  *
 *   Copyright (C) 1999, Gary Meyer <gary@meyer.net>                       *
 *   --------------------------------------------------------------------  *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 ***************************************************************************/

#include "kticon.h"
 
#include <tqimage.h>

#include <kglobal.h>
#include <kiconloader.h>

TQPixmap KTIcon::getMiniIcon(const TQString& name)
{
  return SmallIcon(name);
}

TQPixmap KTIcon::getIcon(const TQString& name)
{
  return BarIcon(name);
}

TQPixmap KTIcon::application(bool mini)
{
  if (mini)
    return getMiniIcon("kcron");
  else
    return getIcon("kcron");
}

TQPixmap KTIcon::system(bool mini)
{
  if (mini)
    return getMiniIcon("openterm");
  else
    return getIcon("openterm");
}

TQPixmap KTIcon::user(bool mini)
{
  if (mini)
    return getMiniIcon("kuser");
  else
    return getIcon("kuser");
}

TQPixmap KTIcon::variables(bool mini)
{
  if (mini)
    return getMiniIcon("folder");
  else
    return getIcon("folder");
}

TQPixmap KTIcon::variable(bool mini)
{
  if (mini)
    return getMiniIcon("mime_empty");
  else
    return getIcon("mime_empty");
}

TQPixmap KTIcon::mail(bool mini)
{
  if (mini)
    return getMiniIcon("mail_generic");
  else
    return getIcon("mail_generic");
}

TQPixmap KTIcon::shell(bool mini)
{
  if (mini)
    return getMiniIcon("openterm");
  else
    return getIcon("openterm");
}

TQPixmap KTIcon::home(bool mini)
{
  if (mini)
    return getMiniIcon("gohome");
  else
    return getIcon("gohome");
}

TQPixmap KTIcon::path(bool mini)
{
  if (mini)
    return getMiniIcon("folder");
  else
    return getIcon("folder");
}

TQPixmap KTIcon::tasks(bool mini)
{
  if (mini)
    return getMiniIcon("folder");
  else
    return getIcon("folder");
}

TQPixmap KTIcon::task(bool mini)
{
  if (mini)
    return getMiniIcon("gear");
  else
    return getIcon("gear");
}
