/*
   Copyright (C) 2000, 2001, 2002 Dawit Alemayehu <adawit@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef __DIR_FILTER_PLUGIN_H
#define __DIR_FILTER_PLUGIN_H

#include <tqmap.h>
#include <tqtimer.h>
#include <tqstringlist.h>


#include <kurl.h>
#include <kfileitem.h>
#include <klibloader.h>
#include <kparts/plugin.h>

class KActionMenu;
class KonqDirPart;
class KLineEdit;


namespace KParts
{
  struct URLArgs;
}

namespace KIO
{
  class Job;
}

class SessionManager
{
public:

  ~SessionManager ();
  static SessionManager* self ();
  TQStringList restoreMimeFilters (const KURL& url) const;
  TQString restoreTypedFilter(const KURL& url) const;
  void save (const KURL& url, const TQStringList& filters);
  void save (const KURL& url, const TQString& typedFilter);

  bool showCount;
  bool useMultipleFilters;

protected:

  TQString generateKey (const KURL& url) const;
  void loadSettings ();
  void saveSettings ();

private:

  SessionManager ();

private:

  int m_pid;
  bool m_bSettingsLoaded;
  static SessionManager* m_self;
  TQMap<TQString,TQStringList> m_filters;
  TQMap<TQString,TQString> m_typedFilter;
};


class DirFilterPlugin : public KParts::Plugin
{
  Q_OBJECT
  TQ_OBJECT

public:

  DirFilterPlugin (TQObject* parent, const char* name, const TQStringList &);
  ~DirFilterPlugin ();

protected:

  struct MimeInfo
  {
    MimeInfo()
    {
      id = 0;
      useAsFilter = false;
    }

    int id;
    bool useAsFilter;

    TQString mimeType;
    TQString iconName;
    TQString mimeComment;

    TQMap<TQString, bool> filenames;
  };

  void loadSettings();
  void saveSettings();

private slots:
  void slotReset();
  void slotTimeout();
  void slotOpenURL();
  void slotShowPopup();
  void slotShowCount();
  void slotMultipleFilters();
  void slotItemSelected(int);
  void slotItemRemoved(const KFileItem *);
  void slotItemsAdded(const KFileItemList &);
  void activateSearch();
  void searchTextChanged(const TQString& newtext);
  void reactivateRefreshTimer();

private:
  KURL m_pURL;
  KonqDirPart* m_part;
  TQTimer *m_refreshTimer;
  TQTimer *m_reactivateRefreshTimer;
  KActionMenu* m_pFilterMenu;
  TQString m_oldFilterString;

  KLineEdit *m_searchWidget;
  TQMap<TQString,MimeInfo> m_pMimeInfo;
  typedef TQMap<TQString,MimeInfo>::Iterator MimeInfoIterator;
};
#endif
