// -*- mode: c++; c-basic-offset: 4 -*-
/*
  Copyright (C) 2006 Daniele Galdi <daniele.galdi@gmail.com>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  
  02110-1301, USA.
*/

#ifndef KONTQ_ADBLOCK_H
#define KONTQ_ADBLOCK_H

#include <tqguardedptr.h>
#include <tqvaluelist.h>
#include <kparts/plugin.h>

class KHTMLPart;
class KURLLabel;
class KHTMLSettings;
class AdElement;
class KPopupMenu;

namespace KParts
{
    class StatusBarExtension;
}

namespace DOM
{
    class DOMString;
}

typedef TQValueList<AdElement> AdElementList;

class AdBlock : public KParts::Plugin
{
    Q_OBJECT
  TQ_OBJECT
    
public:
    AdBlock(TQObject *parent, const char *name, const TQStringList &);
    ~AdBlock();
    
private:
    TQGuardedPtr<KHTMLPart> m_part;    
    KURLLabel *m_label;
    KPopupMenu *m_menu;
    
    void fillBlockableElements(AdElementList &elements);
    void fillWithImages(AdElementList &elements);
    void fillWithHtmlTag(AdElementList &elements, 
			 const DOM::DOMString &tagName, 
			 const DOM::DOMString &attrName,
			 const TQString &category);
    
private slots:
    void initLabel();
    void showDialogue();
    void addAdFilter(const TQString &url);
    void contextMenu();
    void showKCModule();
};

// ----------------------------------------------------------------------------

class AdElement
{
private:
    TQString m_url;
    TQString m_category;
    TQString m_type;
    bool m_blocked;
    
public:
    AdElement();
    AdElement(const TQString &url, const TQString &category,
	      const TQString &type, bool blocked);

    AdElement &operator=(const AdElement &);
    bool operator==(const AdElement &e1);
    
    bool isBlocked() const;
    void setBlocked(bool blocked);
    const TQString &url() const;
    const TQString &category() const;
    const TQString &type() const;
};

#endif
