/***************************************************************************
                           Interface to access JuK
                             -------------------
    begin                : Mon Jan 15 21:09:00 CEST 2001
    copyright            : (C) 2001-2002 by Stefan Gehn
    email                : metz {AT} gehn {DOT} net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef JUKINTERFACE_H
#define JUKINTERFACE_H

#include "playerInterface.h"

#include <kapplication.h>
#include <dcopclient.h>

#include <tqtimer.h>

class TQProcess;

class JuKInterface : public PlayerInterface
{
	Q_OBJECT
  TQ_OBJECT
	public:
		JuKInterface();
		~JuKInterface();

	public slots:
		void updateSlider();
		void sliderStartDrag();
		void sliderStopDrag();
		void jumpToTime( int sec );
		void playpause();
		void stop();
		void next();
		void prev();
		void volumeUp();
		void volumeDown();
		void dragEnterEvent(TQDragEnterEvent* event);
		void dropEvent(TQDropEvent* event);
		const TQString getTrackTitle() const;
		int playingStatus();

	private slots:
		void myInit();
		void appRegistered ( const TQCString &appId );
		void appRemoved ( const TQCString &appId );
		void jukIsReady();

	private:
		TQTimer *mJuKTimer;
		TQProcess *mProc;
		int mTimerValue;
		TQCString mAppId;

		/**
		 * Tries to find a DCOP registered instance of juk
		 * Stores the name of the first found instance in appId
		 * @returns true is instance is found, false otherwise
		 */
		bool findRunningJuK();
};
#endif
