/***************************************************************************
 *   Copyright (C) 2004-2007 by Georgy Yunaev, gyunaev@ulduzsoft.com       *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "kde-qt.h"

#include "libchmfile.h"

#include "kchmcontentswindow.h"
#include "kchmlistitemtooltip.h"
#include "kchmmainwindow.h"
#include "kchmtreeviewitem.h"

#include "kchmcontentswindow.moc"

KCHMContentsWindow::KCHMContentsWindow(TQWidget *parent, const char *name)
	: KQListView(parent, name)
{
	m_contextMenu = 0;
	
	addColumn( "Contents" ); // no i18n - this column is hidden
	setSorting(-1);
	setFocus();
	setRootIsDecorated(true);
	header()->hide();
	setShowToolTips( false );
	
	connect( this, TQT_SIGNAL( onItem ( TQListViewItem * ) ), this, TQT_SLOT( slotOnItem( TQListViewItem * ) ) );
	connect( this, 
			 TQT_SIGNAL( contextMenuRequested( TQListViewItem *, const TQPoint& , int ) ),
			 this, 
			 TQT_SLOT( slotContextMenuRequested ( TQListViewItem *, const TQPoint &, int ) ) );

	
	new KCHMListItemTooltip( this );
}

KCHMContentsWindow::~KCHMContentsWindow()
{
}

void KCHMContentsWindow::slotContextMenuRequested( TQListViewItem * item, const TQPoint & point, int )
{
	if ( !m_contextMenu )
		m_contextMenu = ::mainWindow->currentBrowser()->createListItemContextMenu( this );
		
	if( item )
	{
		KCHMIndTocItem * treeitem = (KCHMIndTocItem*) item;
		::mainWindow->currentBrowser()->setTabKeeper( treeitem->getUrl() );
		m_contextMenu->popup( point );
	}
}

void KCHMContentsWindow::refillTableOfContents( )
{
	TQValueVector< LCHMParsedEntry > data;
	
	if ( !::mainWindow->chmFile()->parseTableOfContents( &data )
	|| data.size() == 0 )
	{
		qWarning ("CHM toc present but is empty; wrong parsing?");
		return;
	}
			   
	kchmFillListViewWithParsedData( this, data, &m_urlListMap );
}

KCHMIndTocItem * KCHMContentsWindow::getTreeItem( const TQString & url )
{
	TQString fixedstr = ::mainWindow->chmFile()->normalizeUrl( url );
	TQMap<TQString, KCHMIndTocItem*>::const_iterator it = m_urlListMap.find( fixedstr );
	
	if ( it == m_urlListMap.end() )
		return 0;
		
	return *it;
}
