/***************************************************************************
 *   Copyright (C) 2007 by Albert Astals Cid, aacid@kde.org                *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <tqdir.h>

#include "tqt34.h"

LIBCHMCString::LIBCHMCString()
{
}

LIBCHMCString::LIBCHMCString(const char *string)
{
#if defined (USE_TQT_4)
	cs = TQByteArray(string);
#else
	cs = TQCString(string);
#endif
}


const char *LIBCHMCString::toCString() const
{
	return cs.data();
}


void LIBCHMCString::clear()
{
#if defined (USE_TQT_4)
	cs = TQByteArray();
#else
	cs = TQCString();
#endif
}

bool LIBCHMCString::operator==(const TQString &string) const
{
	return TQString(cs) == string;
}

uint LIBCHMCString::length() const
{
	return cs.length();
}

bool LIBCHMCString::isEmpty() const
{
	return cs.isEmpty();
}

void LIBCHMCString::prepend(char c)
{
	cs = c + cs;
}

char LIBCHMCString::at(uint i) const
{
	return cs.at(i);
}

void LIBCHMCString::replace(uint index, uint len, const char *str)
{
	cs.replace(index, len, str);
}

void LIBCHMCString::remove(uint index, uint len)
{
	cs.remove(index, len);
}

LIBCHMCString LIBCHMCString::lower()
{
#if defined (USE_TQT_4)
	return cs.toLower().data();
#else
	return cs.lower().data();
#endif
}



LIBCHMRegExp::LIBCHMRegExp(const TQString &regexp)
{
	re = TQRegExp(regexp);
}

int LIBCHMRegExp::search(const TQString &str, int offset)
{
#if defined (USE_TQT_4)
	return re.indexIn(str, offset);
#else
	return re.search(str, offset);
#endif
}

TQString LIBCHMRegExp::cap(int nth)
{
	return re.cap(nth);
}

void LIBCHMRegExp::setMinimal(bool minimal)
{
	return re.setMinimal(minimal);
}

int LIBCHMRegExp::matchedLength() const
{
	return re.matchedLength();
}




LIBCHMString::LIBCHMString()
{
}

LIBCHMString::LIBCHMString(const TQString &string)
{
	s = string;
}

LIBCHMString::LIBCHMString(const char *string)
{
	s = TQString(string);
}

TQString LIBCHMString::lower() const
{
#if defined (USE_TQT_4)
	return s.toLower();
#else
	return s.lower();
#endif
}

const char *LIBCHMString::ascii() const
{
#if defined (USE_TQT_4)
	return s.toAscii();
#else
	return s.ascii();
#endif
}

int LIBCHMString::find(char c, int index) const
{
#if defined (USE_TQT_4)
	return s.indexOf(c, index);
#else
	return s.find(c, index);
#endif
}

int LIBCHMString::find(const TQChar &c, int index) const
{
#if defined (USE_TQT_4)
	return s.indexOf(c, index);
#else
	return s.find(c, index);
#endif
}

int LIBCHMString::find(const TQString &string, int index, bool cs) const
{
#if defined (USE_TQT_4)
	TQt::CaseSensitivity cse;
	if (cs) cse = TQt::CaseSensitive;
	else cse = TQt::CaseInsensitive;
	return s.indexOf(string, index, cse);
#else
	return s.find(string, index, cs);
#endif
}

int LIBCHMString::findRev(char c) const
{
#if defined (USE_TQT_4)
	return s.lastIndexOf(c);
#else
	return s.findRev(c);
#endif
}

TQChar LIBCHMString::at(uint i) const
{
	return s.at(i);
}

TQString LIBCHMString::left(uint len) const
{
	return s.left(len);
}

LIBCHMString LIBCHMString::mid(uint index, uint len) const
{
	return s.mid(index, len);
}

bool LIBCHMString::isEmpty() const
{
	return s.isEmpty();
}

TQString LIBCHMString::toString() const
{
	return s;
}

bool LIBCHMString::operator==(const TQString &string) const
{
	return s == string;
}



TQString LIBCHMDir::cleanDirPath(const TQString &dir)
{
#if defined (USE_TQT_4)
	return TQDir::cleanPath(dir);
#else
	return TQDir::cleanDirPath(dir);
#endif
}



bool LIBCHMStringList::contains(const TQStringList &list, const TQString &string)
{
	return list.contains(string);
}

TQStringList LIBCHMStringList::split(const TQRegExp &regexp, const TQString &string)
{
#if defined (USE_TQT_4)
	return string.split(regexp, TQString::SkipEmptyParts);
#else
	return TQStringList::split(regexp, string);
#endif
}
