/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <config.h>

#include "kbfxplasmapluginloader.h"
#include <tqdir.h>
#include <tqfileinfo.h>
#include <kstandarddirs.h>
#include <kdebug.h>

KbfxPlasmaPluginLoader::KbfxPlasmaPluginLoader()
{
	m_plugin = 0;
	init();

}


void
KbfxPlasmaPluginLoader::init()
{

	TQString libprefix = locate ( "lib","libkbfxdata.so" );
	libprefix.remove ( "libkbfxdata.so" );
//	TQString libprefix = KBFX_LIB_INSTALL_DIR ;
	kdDebug() << "KBFX plugins lib is: " << libprefix << endl;
	TQDir * _dir  = new TQDir ( libprefix+"/kbfx/plugins/" );
	TQStringList plugins;
	_dir->setFilter ( TQDir::Files );
	_dir->setNameFilter ( "*.so" );
	if ( !_dir->exists() )
	{
		kdDebug() << "Invalid Plugin Prefix: " << libprefix << "/kbfx/plugins/" << endl;
		delete _dir;
		return ;//TQStringList("No Plugins found: Error in default Paths.Contact Package Manager");
	}

	const TQFileInfoList *list = _dir->entryInfoList();
	TQFileInfoListIterator it ( *list );
	TQFileInfo *fi=0;
	int _index  =0;
	while ( ( fi = it.current() ) != 0 )
	{
		TQString * path   = new TQString ( libprefix+"/kbfx/plugins/"+fi->fileName() );
		TQLibrary * _l = new TQLibrary ( *path );

		typedef TQString ( *getName ) ();
		getName nameFunc;
		nameFunc = ( getName ) _l->resolve ( "name" );
		if ( nameFunc )
		{
			pluginMap() [nameFunc() ] = new  KbfxPlugin ( nameFunc(),*path,_index++ );
		}
		++it;
		_l->unload();
		delete _l;
		delete path;
	}

	delete  _dir;
}


KbfxPlasmaPluginLoader::~KbfxPlasmaPluginLoader()
{
	//  if(m_plugin!=0)
//	delete m_plugin;

	// PluginMap::Iterator it;
	// for ( it = pluginMap().begin(); it != pluginMap().end(); ++it ) {
	//   delete  it.data();
	//   pluginMap().remove(it);
	//     }


}

KbfxDataStack *
KbfxPlasmaPluginLoader::getView ( TQString name )
{
	PluginMap::Iterator it;
	for ( it = pluginMap().begin(); it != pluginMap().end(); ++it )
	{
		pluginMap().remove ( it );
	}
	init();
	KbfxDataStack * stack = pluginMap() [name] ? pluginMap() [name]->data() : NULL;
	
        if (stack == 0 ) {
            return new KbfxDataStack();
        }

        return stack;
}

KbfxDataGroup *
KbfxPlasmaPluginLoader::search ( TQString pname,TQString keyword )
{
	if ( pname == NULL )
		return NULL;

	KbfxDataGroup * group = pluginMap() [pname]->search ( keyword );
	if ( group == NULL )
	{
		kdDebug() << "KbfxPlasmaaPluginLoader:109:Null pointer" << endl;
		return NULL;
	}

	return group;

}


KbfxPlasmaPluginLoader::PluginMap&
KbfxPlasmaPluginLoader::pluginMap()
{
	static PluginMap  * map = 0;
	if ( !map )
		map = new PluginMap();
	return *map;
}




TQStringList
KbfxPlasmaPluginLoader::scanPlugins()
{

	init();
	TQStringList plugins;
	PluginMap::Iterator it;

	for ( it = pluginMap().begin(); it != pluginMap().end();++it )
	{
		if ( it.data()->status() == false )
			plugins.append ( it.data()->name() );
	}
	return plugins;
}

#include "kbfxplasmapluginloader.moc"
