//**************************************************************************
//   Copyright (C) 2004, 2005 by Petri Damstn
//   petri.damsten@iki.fi
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the
//   Free Software Foundation, Inc.,
//   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//**************************************************************************
#ifndef KBFX_FONT_CHOOSER_H
#define KBFX_FONT_CHOOSER_H

#include <kdialog.h>
#include <kfontdialog.h>
#include <klocale.h>
#include <kiconloader.h>
#include <tqwidget.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqlayout.h>
#include <tqfont.h>
#include <tqsizepolicy.h>

class TQLabel;
class TQPushButton;
class TQFont;

/**
	@author Petri Damsten <petri.damsten@iki.fi>
*/

class KBFXFontChooser : public TQWidget
{
		Q_OBJECT
  TQ_OBJECT
		TQ_PROPERTY ( TQFont font READ font WRITE setFont )
	public:
		KBFXFontChooser ( TQWidget *parent = 0, const char *name = 0 );
		~KBFXFontChooser();

		TQFont font() const { return m_font; };

	public slots:
		void setFont ( const TQFont& font );

	protected:
		void updateFontLabel();

	protected slots:
		void buttonClicked();

	private:
		TQFont m_font;
		TQLabel* m_label;
		TQPushButton* m_button;

	signals:
		void FontChanged();
};

#endif
