/***************************************************************************
                          tokendialog.h  -  description
                             -------------------
    begin                : Sat Oct 23 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tokendialog.h"
#include "tokenprovider.h"
#include "sqltables.h"
#include "dstextedit.h"

#include <klineedit.h>
#include <klistbox.h>
#include <klistview.h>
#include <klocale.h>

#include <tqhbox.h> 
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqsplitter.h>
#include <tqtooltip.h>
#include <tqvaluelist.h>
#include <tqvbox.h>
#include <tqvbuttongroup.h>
#include <tqwidgetstack.h>
#include <tqradiobutton.h>
#include <kcombobox.h>
#include <tqtextbrowser.h>
#include <kpushbutton.h>

TokenDialog::TokenDialog(TokenProvider* token ,TQWidget *parent, const char *name)
    : KWizard( parent, name ), m_token( token )
{
    m_custom_tokens = m_token->listUserVars();

    setupPage1();
    setupPage2();
    setupPage3();

    setupStackPage1();
    setupStackPage2();
 
    setupStack2Page1();
    setupStack2Page2();
    setupStack2Page3();
    setupStack2Page4();
    setupStack2Page5();

    enableControls();
}

void TokenDialog::setupPage1()
{
    TQVButtonGroup* page = new TQVButtonGroup( i18n("What do you want to insert?") );

    radioFixed = new TQRadioButton( i18n("Insert a &fixed data field"), page );
    radioCustom = new TQRadioButton( i18n("Insert a &custom SQL query, variable or JavaScript function"), page );
    
    radioFixed->setChecked( true );

    addPage( page, i18n("Step 1 of 3") );
}

void TokenDialog::setupPage2()
{
    page2 = new TQWidgetStack(0);

    addPage( page2, i18n("Step 2 of 3") );
}

void TokenDialog::setupPage3()
{
    page3 = new TQWidgetStack(0);

    addPage( page3, i18n("Step 3 of 3") );
}

void TokenDialog::setupStackPage1()
{
    stackPage1 = new TQVBox();

    TQVButtonGroup* group = new TQVButtonGroup( i18n("What do you want to insert?"), stackPage1 );
    radioAll = new TQRadioButton( i18n("&Select from a list of all tokens"), group );
    radioLabel = new TQRadioButton( i18n("Insert printing &informations"), group );
    radioSQL = new TQRadioButton( i18n("&Insert a database field"), group );
    radioDate = new TQRadioButton( i18n("Insert a &date/time function"), group );
    radioAddress = new TQRadioButton( i18n("Insert an &addressbook field"), group );

    radioAll->setChecked( true );

    page2->addWidget( stackPage1 );
}

void TokenDialog::setupStackPage2()
{
    stackPage2 = new TQVBox();

    TQVButtonGroup* group = new TQVButtonGroup( i18n("What do you want to insert?"), stackPage2 );

    radioVariable = new TQRadioButton( i18n("Insert a custom &variable"), group );
    radioSQLQuery = new TQRadioButton( i18n("Insert a &SQL query"), group );
    radioJavaScript = new TQRadioButton( i18n("Insert a &JavaScript function"), group );

    radioVariable->setChecked( true );

    connect( radioVariable, TQT_SIGNAL( clicked() ), this, TQT_SLOT( enableControls() ) );
    connect( radioSQLQuery, TQT_SIGNAL( clicked() ), this, TQT_SLOT( enableControls() ) );
    connect( radioJavaScript, TQT_SIGNAL( clicked() ), this, TQT_SLOT( enableControls() ) );

    page2->addWidget( stackPage2 );
}

void TokenDialog::setupStack2Page1()
{
    stack2Page1 = new TQWidget();

    TQVBoxLayout* layout = new TQVBoxLayout( stack2Page1 );
    TQSplitter* splitter = new TQSplitter( stack2Page1 );
    layout->addWidget( splitter );
    
    TQVBox* left = new TQVBox( splitter );
    TQVBox* right = new TQVBox( splitter );
    
    TQLabel* label = new TQLabel( i18n("&Category:"), left );
    category = new KListBox( left );
    label->setBuddy( category );

    label = new TQLabel( i18n("&Token:"), right );
    allList = new KListView( right );
    allList->addColumn( i18n("Token"), 0 );
    allList->addColumn( i18n("Description"), 1 );
    allList->setColumnWidthMode( 0, TQListView::Maximum );
    allList->setColumnWidthMode( 1, TQListView::Maximum );
    label->setBuddy( allList );
    label = new TQLabel( i18n("&Custom Expression to be inserted in the token."), right );
    lineEdit = new KLineEdit( right );
    lineEdit->setEnabled( false );
    label->setBuddy( lineEdit );

    TQToolTip::add( lineEdit, i18n("<qt>Certain tokens, like for exaple the sqlquery token need arguments. "
				  "In the case of the sqlquery token, the sure has to enter a sql query in "
				  "this text field.</qt>" ) );

    TQValueList<int> sizes;
    int w = (width() / 4);
    sizes << w << w * 3;
    
    left->setStretchFactor( category, 2 );
    right->setStretchFactor( allList, 2 );
    splitter->setSizes( sizes );

    connect( category, TQT_SIGNAL( executed( TQListBoxItem* ) ), this, TQT_SLOT( categoryChanged( TQListBoxItem* ) ) );
    connect( allList, TQT_SIGNAL( clicked( TQListViewItem* ) ), this, TQT_SLOT( itemChanged( TQListViewItem* ) ) );

    initAll();

    page3->addWidget( stack2Page1 );
}

void TokenDialog::setupStack2Page2()
{
    stack2Page2 = new TQVBox();

    labelList = new KListView( stack2Page2 );
    labelList->addColumn( i18n("Token"), 0 );
    labelList->addColumn( i18n("Description"), 1 );
    labelList->setColumnWidthMode( 0, TQListView::Maximum );
    labelList->setColumnWidthMode( 1, TQListView::Maximum );

    connect( labelList, TQT_SIGNAL( selectionChanged() ), this, TQT_SLOT( enableControls() ) );
    connect( labelList, TQT_SIGNAL( doubleClicked( TQListViewItem *, const TQPoint &, int ) ), this, TQT_SLOT( accept() ) );

    page3->addWidget( stack2Page2 );
}

void TokenDialog::setupStack2Page3() 
{
    stack2Page3 = new TQVButtonGroup();

    radioVariableNew = new TQRadioButton( i18n("&Create a new custom variable"), stack2Page3 );
    editVariable = new KLineEdit( stack2Page3 );

    radioVariableExisting = new TQRadioButton( i18n("&Insert an existing custom variable"), stack2Page3 );
    listVariable = new KListBox( stack2Page3 );

    radioVariableNew->setChecked( true );

    if( m_token )
        listVariable->insertStringList( m_token->listUserVars() );

    if( !listVariable->count() )
        radioVariableExisting->setEnabled( false );

    connect( radioVariableNew, TQT_SIGNAL( clicked() ), this, TQT_SLOT( enableControls() ) );
    connect( radioVariableExisting, TQT_SIGNAL( clicked() ), this, TQT_SLOT( enableControls() ) );
    connect( editVariable, TQT_SIGNAL( textChanged( const TQString & ) ), this, TQT_SLOT( enableControls() ) );
    connect( listVariable, TQT_SIGNAL( highlighted( int ) ), this, TQT_SLOT( enableControls() ) );
    connect( listVariable, TQT_SIGNAL( doubleClicked( TQListBoxItem*, const TQPoint & ) ), this, TQT_SLOT( accept() ) );

    page3->addWidget( stack2Page3 );
}

void TokenDialog::setupStack2Page4() 
{
    stack2Page4 = new TQVBox();

    if( !SqlTables::isConnected() )
        new TQLabel( i18n("<qt><b>No SQL connection found!</b><br>You can build a query, "
                         "but you will not be able to execute or test it right now.<br></qt>"), stack2Page4 );
    
    TQHBox* hbox = new TQHBox( stack2Page4 );

    TQLabel* label = new TQLabel( i18n("&SQL Query:"), hbox );
    editQuery = new KLineEdit( hbox );
    buttonQuery = new KPushButton( i18n("&Test"), hbox );
    label->setBuddy( editQuery );

    hbox->setStretchFactor( editQuery, 2 );

    new TQLabel( i18n("Query test results:"), stack2Page4 );
    textQueryResults = new TQTextBrowser( stack2Page4 );
    textQueryResults->setReadOnly( true );

    connect( buttonQuery, TQT_SIGNAL( clicked() ), this, TQT_SLOT( testQuery() ) );
    connect( editQuery, TQT_SIGNAL( textChanged( const TQString & ) ), this, TQT_SLOT( enableControls() ) );
        
    page3->addWidget( stack2Page4 );
}

void TokenDialog::setupStack2Page5() 
{
    stack2Page5 = new TQVBox();

    editJavaScript = new DSTextEdit( stack2Page5 );
    editJavaScript->setText( i18n("/* Place your JavaScript code into this text field. */\n") );

    connect( editJavaScript, TQT_SIGNAL( textChanged() ), TQT_SLOT( enableControls() ) );

    page3->addWidget( stack2Page5 );
}

void TokenDialog::accept()
{
    if( radioCustom->isChecked() )
    {
        if( radioVariable->isChecked() ) 
        {
            if( radioVariableNew->isChecked() ) 
            {
                m_result = editVariable->text();
                if( !m_result.startsWith( "$" ) )
                    m_result.prepend( '$' );
            }
            else if( radioVariableExisting->isChecked() )
                m_result = listVariable->currentText();
        }
        else if( radioSQLQuery->isChecked() )
            m_result = TQString( "sqlquery:%2").arg( editQuery->text() );
        else if( radioJavaScript->isChecked() )
            m_result = TQString( "js:%2").arg( editJavaScript->text() );

        m_result = "[" + m_result + "]";
    }
    else
    {
        TQListViewItem* item = ( radioAll->isChecked() ? allList->selectedItem() : labelList->selectedItem() );

        if( item )
        {
            for( unsigned int i = 0; i < m_tokens.count(); i++ )
                if( TQString( "[%1]").arg( m_tokens[i].token ) == item->text( 0 ) )
                {
                    if( m_tokens[i].appendix )
                        m_result =  TQString( "[%1%2]").arg( m_tokens[i].token ).arg( lineEdit->text() );
                    else
                        m_result = item->text( 0 );
                    break;
                }
        }
    }

    KWizard::accept();
}

void TokenDialog::showPage( TQWidget* w )
{
    if( w == page3 ) 
    {
        if( radioCustom->isChecked() ) 
        {
            if( radioVariable->isChecked() )
                page3->raiseWidget( stack2Page3 );
            else if( radioSQLQuery->isChecked() )
                page3->raiseWidget( stack2Page4 );
            else if( radioJavaScript->isChecked() ) 
            {
                page3->raiseWidget( stack2Page5 );
                editJavaScript->setFocus();
            }
        }
        else
        {
            if( radioAll->isChecked() )
                page3->raiseWidget( stack2Page1 );
            else 
            {
                initStackPage2();
                page3->raiseWidget( stack2Page2 );
            }
        }
    }
    else if( w == page2 ) 
    {
        if( radioFixed->isChecked() )
            page2->raiseWidget( stackPage1 );
        else if( radioCustom->isChecked() )
            page2->raiseWidget( stackPage2 );
    }

    KWizard::showPage( w );
}

void TokenDialog::initAll()
{
    unsigned int i, z;
    TQValueList<tCategories>* categories = TokenProvider::getTokens();

    category->insertItem( i18n("All") );
    
    for( i = 0; i < categories->count(); i++ )
        category->insertItem( TokenProvider::captionForCategory( (TokenProvider::ECategories)(*categories)[i].category ) );

    for( i = 0; i < categories->count(); i++ )
	for( z = 0; z < (*categories)[i].tokens.count(); z++ )
	    m_tokens.append( (*categories)[i].tokens[z] );

    if( m_token )
    {
        TQStringList custom_tokens = m_token->listUserVars();
        for( i = 0; i < custom_tokens.count(); i++ )
            m_tokens.append( tToken(  custom_tokens[i], i18n("Variable defined by the user for this label.") ) );
    }

    category->setCurrentItem( 0 );
    categoryChanged( category->item( 0 ) );
}

void TokenDialog::initStackPage2()
{
    TokenProvider::ECategories cat;
    labelList->clear();

    if( radioLabel->isChecked() )
        cat = TokenProvider::CAT_LABEL;
    else if( radioSQL->isChecked() )
        cat = TokenProvider::CAT_DATABASE;
    else if( radioDate->isChecked() )
        cat = TokenProvider::CAT_DATE;
    else if( radioAddress->isChecked() )
        cat = TokenProvider::CAT_ADDRESS;
    else
        return;

    TQValueList<tCategories>* categories = TokenProvider::getTokens();
    for( int i = 0; i < (int)categories->count(); i++ )
    {
        if( (*categories)[i].category == cat )
        {
            for( unsigned int z = 0; z < (*categories)[i].tokens.count(); z++ )
                labelList->insertItem( new KListViewItem( labelList, TQString( "[%1]").arg( (*categories)[i].tokens[z].token ),
                                                     (*categories)[i].tokens[z].description ) );
            
            break;
        }
    }
}

void TokenDialog::categoryChanged( TQListBoxItem* item )
{
    unsigned int i;
    TQValueList<tCategories>* categories = TokenProvider::getTokens();
    allList->clear();
    lineEdit->setEnabled( false );

    if( item->prev() == 0 )
    {
        for( i = 0; i < m_tokens.count(); i++ )
	    allList->insertItem( new KListViewItem( allList, TQString( "[%1]").arg( m_tokens[i].token ),
						 m_tokens[i].description ) );
    } 
    else
    {
        for( i = 0; i < categories->count(); i++ )
        {
            if( TokenProvider::captionForCategory( (TokenProvider::ECategories)(*categories)[i].category ) == item->text() )
            {
                for( unsigned int z = 0; z < (*categories)[i].tokens.count(); z++ )
                    allList->insertItem( new KListViewItem( allList, TQString( "[%1]").arg( (*categories)[i].tokens[z].token ),
                                      (*categories)[i].tokens[z].description ) );
                
                break;
            }
        }

	// TODO: comparing by a user visible string cries for bugs!!!
	if( item->text() == i18n("Custom Values") )
	    for( i=0;i<m_custom_tokens.count();i++ )
		allList->insertItem( new KListViewItem( allList, TQString( "[%1]").arg( m_custom_tokens[i] ), 
						     i18n("Variable defined by the user for this label.") ) );
    }
}

void TokenDialog::itemChanged( TQListViewItem* item )
{
    for( unsigned int i = 0; i < m_tokens.count(); i++ )
    {
	if( TQString( "[%1]").arg( m_tokens[i].token ) == item->text( 0 ) )
	{
	    lineEdit->setEnabled( m_tokens[i].appendix );
	    if(  m_tokens[i].appendix )
		lineEdit->setFocus();
	    break;
	}
    }

    enableControls();
}

void TokenDialog::enableControls()
{
    setFinishEnabled( page3, false );

    listVariable->setEnabled( radioVariableExisting->isChecked() );
    editVariable->setEnabled( radioVariableNew->isChecked() );    

    if( editVariable->isEnabled() && !editVariable->text().isEmpty() ||
        listVariable->isEnabled() && listVariable->currentItem() != -1 ) 
        setFinishEnabled( page3, true );

    buttonQuery->setEnabled( radioSQLQuery->isChecked() && !editQuery->text().isEmpty() && SqlTables::isConnected() );
    if( radioSQLQuery->isChecked() && !editQuery->text().isEmpty() ) 
        setFinishEnabled( page3, true );

    if( radioJavaScript->isChecked() && !editJavaScript->text().isEmpty() )
        setFinishEnabled( page3, true );

    if( !radioCustom->isChecked() )
    {
        if( !radioAll->isChecked() && labelList->selectedItem() )
            setFinishEnabled( page3, true );
        
        if( radioAll->isChecked() && allList->selectedItem() )
            setFinishEnabled( page3, true );
    }
}

void TokenDialog::testQuery()
{
    TQString ret = "[sqlquery:" + editQuery->text() + "]";
    if( m_token )
        ret = m_token->parse( ret );
    textQueryResults->setText( ret );
}

#include "tokendialog.moc"

